#include <bits/stdc++.h>
using namespace std;

void compress(int* begin, int* end) {
    vector <pair <int, int*>> v;

    for (auto it = begin; it != end; it++) {
        v.push_back({*it, it});
    }

    sort(v.begin(), v.end());

    int cnt = 0;

    for (int i = 0; i < v.size(); i++) {
        if (i == 0 || v[i].first != v[i - 1].first) cnt++;
        (*(v[i].second)) = cnt;
    }
}

const int MAXN = 1e6 + 10;
int sa[MAXN], sb[MAXN];
int a[MAXN], b[MAXN];

int main() {

    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    int n;
    cin >> n;

    for (int i = 1; i <= n; i++) {
        cin >> a[i] >> b[i];
    }

    compress(a + 1, a + n + 1);
    compress(b + 1, b + n + 1);

    for (int i = 1; i <= n + 1; i++) {
        sa[i] = INT_MAX;
        sb[i] = INT_MAX;
    }

    for (int i = 1; i <= n; i++) {
        sa[a[i]] = min(sa[a[i]], b[i]);
        sb[b[i]] = min(sb[b[i]], a[i]);
    }

    for (int i = n; i >= 1; i--) {
        sa[i] = min(sa[i], sa[i + 1]);
        sb[i] = min(sb[i], sb[i + 1]);
    }

    int va = 0, vb = 0;

    for (int i = 1; i <= n; i++) {
        va = max(va, a[i]);
        vb = max(vb, b[i]);
    }

    //cout << va << ' ' << vb << '\n';

    while (1) {
        int nb = sa[va];
        int na = sb[vb];

        bool f = 0;

        if (na < va) f = 1;
        if (nb < vb) f = 1;
        va = na;
        vb = nb;

        //cout << va << ' ' << vb << '\n';

        if (!f) break;
    }

    for (int i = 1; i <= n; i++) {
        if (a[i] >= va) cout << "W";
        else cout << "L";
    }

    cout << '\n';

    return 0;

}