#include <iostream>
#include <algorithm>
#include <random>
#include <vector>
#include <stack>
#include <queue>
#include <set>
#include <map>

#define int long long

const int MAXN = 5 * 1000 + 10;
const int MAXM = 2 * MAXN;
const int INF = 1e18 + 10;

int n, m;
int color[MAXN];
std::vector<int> g[MAXN];
bool onlyMinus;

bool dfs(int node)
{
    color[node] = 1;

    for(const int &to : g[node])
    {
        if(color[to] == 0)
        {
            bool res = dfs(to);
            if(res) return true;
        } 
        else if(color[to] == 1)
        {
            return true;
        }
    }

    color[node] = 2;
    return false;
}

void solve()
{
    bool hasCycle = dfs(1);

    if(!hasCycle)
    {
        std::cout << "0" << "\n";
    }
    else
    {
        if(onlyMinus)
        {
            std::cout << "1" << "\n";
        }
        else
        {
            std::cout << "0" << "\n";
        }
    }
}

void input()
{
    std::cin >> n >> m;
    for(int i = 1 ; i <= m ; ++i)
    {
        int a, b, c;
        std::cin >> a >> b >> c;
        if(c < 0) onlyMinus = true;

        a += 1, b += 1;
        g[a].push_back(b);
    }
}

void fastIO()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
    std::cout.tie(NULL);
}

signed main()
{
    fastIO();
    input();
    solve();
    return 0;
}