#include <iostream>
#include <algorithm>
#include <random>
#include <vector>
#include <stack>
#include <queue>
#include <set>
#include <map>

#define int long long

const int MAXN = 5 * 1000 + 10;
const int MAXM = 2 * MAXN;
const int INF = 1e18 + 10;

struct Edge
{
    int a;
    int b;
    int c;
};

int n, m;
int dist[MAXN];
bool vis[MAXN];
int degree[MAXN];
int component[MAXN];
std::vector<Edge> edges;
std::vector<int> g[MAXN];
std::vector<int> rev[MAXN];
std::vector<int> scc[MAXN];
std::vector<int> sources;
std::vector<int> topo;
int cnt;

void dfs1(int node)
{
    vis[node] = 1;

    for(const int &to : g[node])
    {
        if(!vis[to])
        {
            dfs1(to);
        }
    }

    topo.push_back(node);
}

void dfs2(int node)
{
    vis[node] = 1;
    component[node] = cnt;
    scc[cnt].push_back(node);

    for(const int &to : rev[node])
    {
        if(!vis[to])
        {
            dfs2(to);
        }
    }
}

void bellman()
{
    for(int source : sources)
    {
        std::fill(dist + 1, dist + n + 1, INF);
        dist[source] = 0;

        for(int j = 1 ; j <= n - 1 ; ++j)
        {
            for(auto &[a, b, c] : edges)
            {
                if(dist[a] == INF) continue;
                dist[b] = std::min(dist[b], dist[a] + c);
            }
        }

        for(auto &[a, b, c] : edges)
        {
            if(dist[a] == INF) continue;

            if(dist[b] > dist[a] + c)
            {
                std::cout << "1" << "\n";
                exit(0);
            }
        }
    }

    std::cout << "0" << "\n";
}

void solve()
{
    for(int i = 1 ; i <= n ; ++i)
    {
        if(!vis[i])
        {
            dfs1(i);
        }
    }

    std::fill(vis + 1, vis + n + 1, 0);
    while(topo.size())
    {
        int node = topo.back();
        if(!vis[node])
        {
            cnt += 1;
            dfs2(node);
        }

        topo.pop_back();
    }

    for(int i = 1 ; i <= n ; ++i)
    {
        for(int j : g[i])
        {
            if(component[i] != component[j])
            {
                degree[j] += 1;
            }
        }
    }

    for(int i = 1 ; i <= cnt ; ++i)
    {
        if(degree[i] = 0)
        {
            sources.push_back(scc[i][0]);
        }
    }

    bellman();
}

void input()
{
    std::cin >> n >> m;
    for(int i = 1 ; i <= m ; ++i)
    {
        int a, b, c;
        std::cin >> a >> b >> c;
        a += 1, b += 1;
        edges.push_back({a, b , c});
        g[a].push_back(b);
        rev[b].push_back(a);
    }
}

void fastIO()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
    std::cout.tie(NULL);
}

signed main()
{
    fastIO();
    input();
    solve();
    return 0;
}