#include <iostream>
#include <algorithm>
#include <random>
#include <vector>
#include <stack>
#include <queue>
#include <set>
#include <map>

#define int long long

const int MAXN = 5 * 1000 + 10;
const int MAXM = 2 * MAXN;
const int INF = 1e18 + 10;

struct Edge
{
    int a;
    int b;
    int c;
};

int n, m;
int dist[MAXN];
std::vector<Edge> edges;
std::map<int, int> map;

int randomSource()
{
    int s = 1;
    while(map[s])
    {
        s = rand() % n;
        if(s == 0) s = 1;
    }

    map[s] = 1;
    return s;
}

void solve()
{
    for(int cnt = 1 ; cnt <= 20 ; ++cnt)
    {
        int source = randomSource();
        std::fill(dist + 1, dist + n + 1, INF);
        dist[source] = 0;

        for(int j = 1 ; j <= n - 1 ; ++j)
        {
            for(auto &[a, b, c] : edges)
            {
                if(dist[a] == INF) continue;
                dist[b] = std::min(dist[b], dist[a] + c);
            }
        }

        for(auto &[a, b, c] : edges)
        {
            if(dist[a] == INF) continue;

            if(dist[b] > dist[a] + c)
            {
                std::cout << "1" << "\n";
                exit(0);
            }
        }
        
    }

    std::cout << "0" << "\n";
}

void input()
{
    std::cin >> n >> m;
    for(int i = 1 ; i <= m ; ++i)
    {
        int a, b, c;
        std::cin >> a >> b >> c;
        edges.push_back({a + 1, b + 1, c});
    }
}

void fastIO()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
    std::cout.tie(NULL);
}

signed main()
{
    fastIO();
    input();
    solve();
    return 0;
}