#include <iostream>
#include <algorithm>
#include <vector>
#include <stack>
#include <queue>
#include <set>
#include <map>

#define int long long

const int MAXN = 200000 + 10;
const int INF = 1e9 + 10;

int n, m, q;

struct Element
{
    int a;
    int b;
};

int query[MAXN];
Element cl[MAXN];
int center[MAXN];
int ans[MAXN];

struct Pair
{
    int l;
    int r;
    int idx;
};

std::vector<Pair> v;

void solve()
{
    for(int i = 1 ; i <= n ; ++i)
    {
        int l = (m - 1) - cl[i].b + 1;
        int r = (cl[i].b + cl[i].a) % m - 1;
        center[i] = (cl[i].a - (l + r)) / m;
        v.push_back({cl[i].b, (cl[i].b + cl[i].a) % m - 1, -1});
    }

    std::sort(v.begin(), v.end(), [&](const Pair &a, const Pair &b)
    {
        if(a.l == b.l)
        {
            return a.r < b.r;
        }

        return a.l < b.l;
    });

    int cnt = 0;
    for(auto [l, r, idx] : v)
    {
        if(r == 0)
        {
            ans[idx] = cnt;
        }

        cnt += 1;
    }
}


void input()
{
    std::cin >> n >> m;
    for(int i = 1 ; i <= n ; ++i)
    {
        std::cin >> cl[i].a >> cl[i].b;
    }

    std::cin >> q;
    for(int i = 1 ; i <= q ; ++i)
    {
        int x;
        std::cin >> x;
        v.push_back({x, +INF, i});
    }
}

void output()
{
    int fixed = 0;
    for(int i = 1 ; i <= n ; ++i)
    {
        fixed += center[i];
    }
    
    for(int i = 1 ; i <= q ; ++i)
    {
        std::cout << ans[i] + fixed << "\n";
    }
}


void fastIO()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
    std::cout.tie(NULL);
}

signed main()
{
    fastIO();
    input();
    solve();
    output();
    return 0;
}