#include <iostream>
#include <algorithm>
#include <vector>
#include <stack>
#include <queue>
#include <set>
#include <map>

#define int long long

const int MAXN = 200000 + 10;
const int INF = 1e9 + 10;

int n, m, q;

struct Element
{
    int a;
    int b;
};

int query[MAXN];
Element cl[MAXN];
int ans[MAXN];

void solve()
{
    for(int i = 1 ; i <= n ; ++i)
    {
        for(int j = 1 ; j <= q ; ++j)
        {
            //cl[i].a, cl[i].b, query[i]
            /*int left = (m - 1) - cl[i].b + 1;
            int right = (cl[i].b + cl[i].a) % m - 1;
            int sum = (cl[i].a - (left + right)) / m + (cl[i].b <= query[i]) + (right <= query[i]);*/
            int left = (cl[i].b <= query[j]);
            int right = (query[j] <= (cl[i].b + cl[i].a) % m - 1);

            int l = (m - 1) - cl[i].b + 1;
            int r = (cl[i].b + cl[i].a) % m - 1;

            int center = (cl[i].a - (l + r)) / m;
            ans[j] += left + center + right;
        }
    }
}


void input()
{
    std::cin >> n >> m;
    for(int i = 1 ; i <= n ; ++i)
    {
        std::cin >> cl[i].a >> cl[i].b;
    }

    std::cin >> q;
    for(int i = 1 ; i <= q ; ++i)
    {
        std::cin >> query[i];
    }
}

void output()
{
    for(int i = 1 ; i <= q ; ++i)
    {
        std::cout << ans[i] << "\n";
    }
}


void fastIO()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
    std::cout.tie(NULL);
}

signed main()
{
    fastIO();
    input();
    solve();
    output();
    return 0;
}