#include <iostream>
#include <algorithm>
#include <vector>
#include <stack>
#include <queue>
#include <set>
#include <map>

const int MAXN = 1000000 + 10;
const int INF = 1e9 + 10;

int n;
struct SegmentTreeMAX
{
    struct Node
    {
        int max;
        int idx;
    
        Node()
        {
            max = -INF;
            idx = -1;
        }

        void set(int x, int i)
        {
            max = x;
            idx = i;
        }

        friend Node operator + (const Node &left, const Node &right)
        {
            if(left.max == right.max)
            {
                return (left.idx < right.idx ? left : right);
            }

            return (left.max > right.max ? left : right);
        }
    };

    Node tree[4 * MAXN];

    void build(int node, int l, int r, int arr[])
    {
        if(l == r)
        {
            tree[node].set(arr[l], l);
            return;
        }

        int mid = l + r >> 1;
        build(2*node, l, mid, arr);
        build(2*node + 1, mid + 1, r, arr);
        tree[node] = tree[2*node] + tree[2*node + 1];
    }

    Node query(int node, int l, int r, int queryL, int queryR)
    {
        if(queryL <= l && r <= queryR)
        {
            return tree[node];
        }

        Node res;
        int mid = l + r >> 1;
        if(queryL <= mid) res = res + query(2*node, l, mid, queryL, queryR);
        if(mid + 1 <= queryR) res = res + query(2*node + 1, mid + 1, r, queryL, queryR);
        return res;
    }
};

/*struct SegmentTreeMAX
{
    int tree[4 * MAXN];

    void build(int node, int l, int r, int arr[])
    {
        if(l == r)
        {
            tree[node] = arr[l];
            return;
        }

        int mid = l + r >> 1;
        build(2*node, l, mid, arr);
        build(2*node + 1, mid + 1, r, arr);
        tree[node] = std::max(tree[2*node], tree[2*node + 1]);
    }

    int query(int node, int l, int r, int queryL, int queryR)
    {
        if(queryL <= l && r <= queryR)
        {
            return tree[node];
        }

        int res = -INF;
        int mid = l + r >> 1;
        if(queryL <= mid) res = std::max(res, query(2*node, l, mid, queryL, queryR));
        if(mid + 1 <= queryR) res = std::max(res, query(2*node + 1, mid + 1, r, queryL, queryR));
        return res;
    }

    int descent(int node, int l, int r, int queryL, int queryR, int k)
    {
        if(r < queryL || l > queryR)
        {
            return -1;
        }

        if(tree[node] <= k)
        {
            return -1;
        }

        if(l == r)
        {
            return l;
        }   

        int mid = l + r >> 1;
        int res = descent(2*node, l, mid, queryL, queryR, k);
        if(res != -1) return res;
        return descent(2*node + 1, mid + 1, r, queryL, queryR, k);
    }
};*/

struct SegmentTreeMIN
{
    int tree[4 * MAXN];

    void build(int node, int l, int r, int arr[])
    {
        if(l == r)
        {
            tree[node] = arr[l];
            return;
        }

        int mid = l + r >> 1;
        build(2*node, l, mid, arr);
        build(2*node + 1, mid + 1, r, arr);
        tree[node] = std::min(tree[2*node], tree[2*node + 1]);
    }

    int descent(int node, int l, int r, int queryL, int queryR, int k)
    {
        if(r < queryL || l > queryR)
        {
            return -1;
        }

        if(tree[node] > k)
        {
            return -1;
        }

        if(l == r)
        {
            return l;
        }   

        int mid = l + r >> 1;
        int res = descent(2*node, l, mid, queryL, queryR, k);
        if(res != -1) return res;
        return descent(2*node + 1, mid + 1, r, queryL, queryR, k);
    }
};

struct Person
{
    int a;
    int b;
    int idx;
};

int arr[MAXN];
Person person[MAXN];
SegmentTreeMAX treeMAX;
SegmentTreeMIN treeMIN;
char ans[MAXN];

void solve()
{
    std::sort(person + 1, person + n + 1, [&](const Person &x, const Person &y)
    {
        if(x.a == y.a)
        {
            return x.b < y.b;
        }

        return x.a > y.a;
    });

    for(int i = 1 ; i <= n ; ++i)
    {
        arr[i] = person[i].b;
    }

    treeMAX.build(1, 1, n, arr);
    treeMIN.build(1, 1, n, arr);
    for(int i = 1 ; i <= n ; ++i)
    {
        if(i == 1)
        {
            ans[person[i].idx] = 'W';
            continue;
        }

        

        SegmentTreeMAX::Node left = treeMAX.query(1, 1, n, 1, i - 1);
        SegmentTreeMAX::Node right = treeMAX.query(1, 1, n, i, n);

        //std::cout << "l: " << leftMAX << "\n";
        //std::cout << "r: " << rightMAX << "\n";

        if(left.max <= right.max)
        {
            ans[person[i].idx] = 'W';
            continue;
        }

        int idx = treeMIN.descent(1, 1, n, 1, i - 1, right.max);
        
        //int idx2 = treeMAX.descent(1, 1, n, 1, i - 1, rightMAX);
        //std::cout << "s: " << idx << " " << idx2 << "\n";

        if(idx != -1 && idx <= left.idx)
        {
            ans[person[i].idx] = 'W';
        }
        else
        {
            ans[person[i].idx] = 'L';
        }
    }

    for(int i = 1 ; i <= n ; ++i)
    {
        std::cout << ans[i];
    }

    std::cout << "\n";
}

void input()
{
    std::cin >> n;
    for(int i = 1 ; i <= n ; ++i)
    {
        std::cin >> person[i].a >> person[i].b;
        person[i].idx = i;
    }
}


void fastIO()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
    std::cout.tie(NULL);
}

int main()
{
    fastIO();
    input();
    solve();
    return 0;
}