#include <iostream>
#include <algorithm>
#include <vector>
#include <stack>
#include <queue>
#include <set>
#include <map>

const int MAXN = 1000000 + 10;
const int INF = 1e9 + 10;

int n;
struct Person
{
    int a;
    int b;
};

char ans[MAXN];
Person person[MAXN];
std::vector<int> g[MAXN];
std::vector<int> rev[MAXN];
std::vector<int> scc[MAXN];
std::vector<int> topo;
int component[MAXN];
bool vis[MAXN];
int in[MAXN];
int out[MAXN];
int cnt;

void dfs1(int node)
{
    vis[node] = 1;

    for(const int &to : g[node])
    {
        if(!vis[to])
        {
            dfs1(to);
        }
    }

    topo.push_back(node);
}

void dfs2(int node)
{
    vis[node] = 1;
    component[node] = cnt;
    scc[cnt].push_back(node);

    for(const int &to : rev[node])
    {
        if(!vis[to])
        {
            dfs2(to);
        }
    }
}

bool can(int i, int j)
{
    return person[i].a >= person[j].a || person[i].b >= person[j].b;
}

void solve()
{
    for(int i = 1 ; i <= n ; ++i)
    {
        for(int j = 1 ; j <= n ; ++j)
        {
            if(can(i, j))
            {
                g[i].push_back(j);
                rev[j].push_back(i);
            }
        }
    }

    for(int i = 1 ; i <= n ; ++i)
    {
        if(!vis[i])
        {
            dfs1(i);
        }
    }

    std::fill(vis + 1, vis + n + 1, 0);
    while(topo.size())
    {
        int node = topo.back();
        if(!vis[node])
        {
            cnt += 1;
            dfs2(node);
        }

        topo.pop_back();
    }

    for(int i = 1 ; i <= n ; ++i)
    {
        for(int j : g[i])
        {
            if(component[i] != component[j])
            {
                out[i] += 1;
                in[j] += 1;
            }
        }
    }

    std::fill(ans + 1, ans + n + 1, 'L');

    for(int i = 1 ; i <= cnt ; ++i)
    {
        if(in[i] == 0 && out[i] == 0)
        {
            for(int i = 1 ; i <= n ; ++i)
            {
                std::cout << ans[i];
            }

            std::cout << "\n";
            exit(0);
        }
    }

    for(int i = 1 ; i <= cnt ; ++i)
    {
        if(in[i] == 0)
        {
            for(int s : scc[i])
            {
                ans[s] = 'W';
            }
        }
    }

    for(int i = 1 ; i <= n ; ++i)
    {
        std::cout << ans[i];
    }

    std::cout << "\n";

    /*for(int i = 1 ; i <= n ; ++i)
    {
        cnt = 0; dfs(i);
        if(cnt == n) std::cout << "W";
        else std::cout << "L";
        std::fill(vis + 1, vis + n + 1, 0);
    }*/
}

void input()
{
    std::cin >> n;
    for(int i = 1 ; i <= n ; ++i)
    {
        std::cin >> person[i].a >> person[i].b;
    }
}

void fastIO()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
    std::cout.tie(NULL);
}

int main()
{
    fastIO();
    input();
    solve();
    return 0;
}