#include <iostream>
#include <algorithm>
#include <vector>
#include <stack>
#include <queue>
#include <set>
#include <map>

const int MAXN = 1000000 + 10;
const int INF = 1e9 + 10;

int n;
struct Person
{
    int a;
    int b;
};

Person person[MAXN];
std::vector<int> g[MAXN];
bool vis[MAXN];
int cnt;

void dfs(int node)
{
    vis[node] = 1;
    cnt += 1;

    for(const int &to : g[node])
    {
        if(!vis[to])
        {
            dfs(to);
        }
    }
}

bool can(int i, int j)
{
    return person[i].a >= person[j].a || person[i].b >= person[j].b;
}

void solve()
{
    for(int i = 1 ; i <= n ; ++i)
    {
        for(int j = 1 ; j <= n ; ++j)
        {
            if(can(i, j))
            {
                g[i].push_back(j);
            }
        }
    }

    for(int i = 1 ; i <= n ; ++i)
    {
        cnt = 0; dfs(i);
        if(cnt == n) std::cout << "W";
        else std::cout << "L";
        std::fill(vis + 1, vis + n + 1, 0);
    }
}

void input()
{
    std::cin >> n;
    for(int i = 1 ; i <= n ; ++i)
    {
        std::cin >> person[i].a >> person[i].b;
    }
}


void fastIO()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
    std::cout.tie(NULL);
}

int main()
{
    fastIO();
    input();
    solve();
    return 0;
}