# include <bits/stdc++.h>
# define ll long long
using namespace std;

const int MAXN = 5 * 1e3 + 1, INF = 1e9;
int n, m;
vector<pair<int, ll>> graph[MAXN];
bool reachable[MAXN][MAXN];
int answer = 0;

void upgrade_speed()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
}

int start;

void dfs(int u)
{
    if(reachable[start][u]) return;
    reachable[start][u] = true;

    for(auto& [v, w] : graph[u])
    {
        dfs(v);
    }
}

void read()
{
    cin >> n >> m;

    for(int i = 0; i < m; i++)
    {
        int u, v, w; cin >> u >> v >> w;
        if(w <= 0)graph[u].push_back({v, (ll)w});
    }

    for(start = 0; start < n; start++)
    {
        dfs(start);
    }

    for(int u = 0; u < n; u++)
    {
        for(int v = u + 1; v < n; v++)
        {
            if(reachable[u][v] && reachable[v][u])
            {
                answer = 1;
                break;
            }
        }

        if(answer == 1) break;
    }
}

void solve()
{
    cout << answer;
}

int main()
{
    upgrade_speed();
    read();
    solve();
    return 0;
}


