# include <bits/stdc++.h>
# define ll long long
using namespace std;

const int MAXN = 5 * 1e3 + 1, INF = 1e9;
int n, m;
vector<pair<int, ll>> graph[MAXN];
ll dp[MAXN][MAXN];
int answer = 0;
bool reachable[MAXN][MAXN];

int start;

void dfs(int u)
{
    if(reachable[start][u]) return;
    reachable[start][u] = true;

    for(auto& [v, w] : graph[u])
    {
        dfs(v);
    }
}


void upgrade_speed()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
}

void dejikstra(int start)
{
    int cycles = 0;
    vector<int> last_value(n + 1, 0);

    for(int u = 0; u < n; u++)
    {
        dp[start][u] = INF;
    }

    dp[start][start] = 0;

    priority_queue<pair<ll, int>> pq;
    pq.push({0, start});

    while(!pq.empty())
    {
        int u = pq.top().second;
        pq.pop();
        cycles++;

        for(auto& [v, w] : graph[u])
        {
            if(!reachable[v][start]) continue;
            if(v == start && dp[start][u] + w <= 0)
            {
                answer = 1;
                return;
            }

            if(dp[start][v] > dp[start][u] + w)
            {
                dp[start][v] = (ll)(dp[start][u] + w);
                last_value[v]++;
                if(last_value[v] > n * n) break;
                pq.push({-dp[start][v], v});
            }
        }
    }
}

void read()
{
    cin >> n >> m;

    for(int i = 0; i < m; i++)
    {
        int u, v, w; cin >> u >> v >> w;
        graph[u].push_back({v, (ll)w});
    }

    for(start = 0; start < n; start++)
    {
        dfs(start);
    }

    for(int start = 0; start < n; start++)
    {
        dejikstra(start);
    }

    for(int u = 0; u < n; u++)
    {
        for(int v = u + 1; v < n; v++)
        {
            if(dp[u][v] + dp[v][u] <= 0)
            {
                answer = 1;
                break;
            }
        }

        if(answer == 1) break;
    }
}

void solve()
{
    cout << answer;
}

int main()
{
    upgrade_speed();
    read();
    solve();
    return 0;
}
