# include <bits/stdc++.h>
# define ll long long
using namespace std;

const int MAXN = 5 * 1e3 + 11;
int n, m;
vector<pair<int, int>> graph[MAXN];
int answer = 0;
bool reachable[MAXN][MAXN];
int dp[MAXN][MAXN];
bool visited[MAXN][MAXN];

void upgrade_speed()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
}

int start;

void dfs(int u)
{
    if(reachable[start][u]) return;
    reachable[start][u] = true;

    for(auto& [v, w] : graph[u])
    {
        dfs(v);
    }
}

int counter = 0;

void dfs_solve(int st, int u, ll current)
{
    if(answer == 1) return;
    dp[st][u] = current;
    visited[st][u] = true;
    ///cout << start << " " << u << " " << current << '\n';

    for(auto& [v, w] : graph[u])
    {
        if(reachable[v][st] && (!visited[st][v] || dp[st][v] > dp[st][u] + w))
        {
            if(reachable[v][u])
            {
                if(v == st && current <= 0)
                {
                    answer =1;
                    return;
                }

                dfs_solve(u, u, 0);
            }

            dfs_solve(st, v, current + w);
        }
    }
}


void read()
{
    cin >> n >> m;

    for(int i = 0; i < m; i++)
    {
        int u, v, w;
        cin >> u >> v >> w;
        graph[u].push_back({v, w});
    }

    for(int u = 0; u < n; u++)
    {
        for(int v = 0; v < n; v++) dp[u][v] = 1e9;
    }

    dfs(0);

    for(start = 0; start < n; start++)
    {
        dfs_solve(start, start, 0);
        if(answer == 1) return;
    }
}

void solve()
{
    cout << answer;
}

int main()
{
    upgrade_speed();
    read();
    solve();
    return 0;
}
