# include <bits/stdc++.h>
# define ll long long
using namespace std;

const int MAXN = 501, INF = 1e9;
int n, m;
vector<pair<int, int>> graph[MAXN];
int answer = 0;
bool reachable[MAXN][MAXN];

void upgrade_speed()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
}

int start;

void dfs(int u)
{
    if(reachable[start][u]) return;
    reachable[start][u] = true;

    for(auto& [v, w] : graph[u])
    {
        dfs(v);
    }
}

void dfs_solve(int u, ll current)
{
    if(answer == 1) return;

    for(auto& [v, w] : graph[u])
    {
        if(reachable[v][u])
        {
            if(v == start)
            {
                if(current + w <= 0)
                {
                    answer = 1;
                    return;
                }
            }
            dfs_solve(v, current + w);
        }
        else
        {
            return;
        }
    }
}

void read()
{
    cin >> n >> m;

    for(int i = 0; i < m; i++)
    {
        int u, v, w; cin >> u >> v >> w;
        graph[u].push_back({v, w});
    }

    for(start = 0; start < n; start++)
    {
        dfs(start);
    }

    for(start = 0; start < n; start++)
    {
        dfs_solve(start, 0);
        if(answer == 1) return;
    }
}

void solve()
{
    cout << answer;
}

int main()
{
    upgrade_speed();
    read();
    solve();
    return 0;
}
