# include <bits/stdc++.h>
# define ll long long
using namespace std;

const int MAXN = 5 * 1e3 + 1, INF = 1e9;
int n, m;
vector<pair<int, ll>> graph[MAXN];
int answer = 0;
int depth[MAXN][MAXN];
bool visited[MAXN][MAXN];

void upgrade_speed()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
}

int start;

void dfs(int u, ll current)
{
    if(answer == 1) return;
    visited[start][u] = true;

    for(auto& [v, w] : graph[u])
    {
        if(!visited[start][v] || depth[start][v] > depth[start][u])
        {
            depth[start][v] = max(depth[start][v], depth[start][u] + 1);
            dfs(v, current + w);
        }
        else
        {
            if(current + w <= 0)
            {
                answer = 1;
                return;
            }
        }
    }
}

void read()
{
    cin >> n >> m;

    for(int i = 0; i < m; i++)
    {
        int u, v, w; cin >> u >> v >> w;
        graph[u].push_back({v, (ll)w});
    }

    for(start = 0; start < n; start++)
    {
        dfs(start, 0);
        if(answer == 1) return;
    }
}

void solve()
{
    cout << answer;
}

int main()
{
    upgrade_speed();
    read();
    solve();
    return 0;
}
