# include <bits/stdc++.h>
# define ll long long
using namespace std;

const int MAXN = 5 * 1e3 + 1, INF = 1e9;
int n, m;
set<pair<ll, int>> graph[MAXN];
bool reachable[MAXN][MAXN];
int answer = 0;
ll dp[MAXN][MAXN];

void upgrade_speed()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
}

int start;

void dfs(int u, ll current)
{
    dp[start][u] = min(dp[start][u], current);
    if(reachable[start][u]) return;
    reachable[start][u] = true;

    for(auto& [w, v] : graph[u])
    {
        dfs(v, current - w);
    }
}

void read()
{
    cin >> n >> m;

    for(int i = 0; i < m; i++)
    {
        int u, v, w; cin >> u >> v >> w;
        graph[u].insert({(ll)(-w), v});
    }

    for(int u = 0; u < n; u++)
    {
        for(int v = 0; v < n; v++) dp[u][v] = INF;
    }

    for(start = 0; start < n; start++)
    {
        dfs(start, 0);
    }

    for(int u = 0; u < n; u++)
    {
        for(int v = u + 1; v < n; v++)
        {
            if(dp[u][v] + dp[v][u] <= 0)
            {
                answer = 1;
                break;
            }
        }

        if(answer == 1) break;
    }
}

void solve()
{
    cout << answer;
}

int main()
{
    upgrade_speed();
    read();
    solve();
    return 0;
}
