# include <bits/stdc++.h>
# define ll long long
using namespace std;

const int MAXN = 5 * 1e3 + 1, INF = 1e9;
int n, m;
vector<pair<int, ll>> graph[MAXN];
ll dp[MAXN][MAXN];
int answer = 0;

void upgrade_speed()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
}

void dejikstra(int start)
{
    int cycles = 0;

    for(int u = 0; u < n; u++)
    {
        dp[start][u] = INF;
    }

    dp[start][start] = 0;

    priority_queue<pair<ll, int>> pq;
    pq.push({0, start});

    while(!pq.empty())
    {
        int u = pq.top().second;
        pq.pop();
        cycles++;
        if(cycles > 2 * (n + m))
        {
            return;
        }

        for(auto& [v, w] : graph[u])
        {
            ///cout << " start is " << start << " " << v << " " << u << " dp is " << dp[start][u] << " weight is : " << w << '\n';
            if(v == start && dp[start][u] + w <= 0)
            {
                answer = 1;
                return;
            }

            if(dp[start][v] > dp[start][u] + w)
            {
                dp[start][v] = (ll)(dp[start][u] + w);
                pq.push({-dp[start][v], v});
            }
        }
    }
}

void read()
{
    cin >> n >> m;

    for(int i = 0; i < m; i++)
    {
        int u, v, w; cin >> u >> v >> w;
        graph[u].push_back({v, (ll)w});
    }

    for(int start = 0; start < n; start++)
    {
        dejikstra(start);
        if(answer == 1) break;
    }
}

void solve()
{
    cout << answer;
}

int main()
{
    upgrade_speed();
    read();
    solve();
    return 0;
}

