# include <bits/stdc++.h>
# define ll long long
using namespace std;

const int MAXN = 1e6 + 1;
int n;
int a[MAXN], b[MAXN];
vector<tuple<int, int, int>> ab, ba;
vector<pair<int, int>> edges;
bool visited[MAXN];
int leader_a, leader_b;
int root[MAXN];
int sz[MAXN];

int find_root(int u)
{
    if(u == root[u]) return u;
    return root[u] = find_root(root[u]);
}

void unite(int u, int v)
{
    u = find_root(u);
    v = find_root(v);
    if(u == v) return;
    if(sz[u] < sz[v]) swap(u, v);
    root[v] = u;
    sz[u] += sz[v];
}

int Max(int& x, int& y)
{
    if(x >= y) return x;
    return y;
}

void upgrade_speed()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
}


void read()
{
    cin >> n;

    for(int i = 1; i <= n; i++)
    {
        cin >> a[i] >> b[i];
        ab.push_back({a[i], -b[i], i});
        ba.push_back({b[i], -a[i], i});
        leader_a = Max(leader_a, a[i]);
        leader_b = Max(leader_b, b[i]);
    }

    sort(ab.begin(), ab.end());
    sort(ba.begin(), ba.end());

    for(int i = 1; i < n; i++)
    {
        edges.push_back({get<2>(ab[i - 1]), get<2>(ab[i])});
    }

    for(int u = 1; u <= n; u++)
    {
        root[u] = u;
        sz[u] = 1;
    }

    for(int i = 1; i < n; i++)
    {
        edges.push_back({get<2>(ba[i - 1]), get<2>(ba[i])});
    }

    for(auto& [u, v] : edges) unite(u, v);
}

void solve()
{
    int special_index;

    for(int i = 1; i <= n; i++)
    {
        if(a[i] == leader_a || b[i] == leader_b)
        {
            special_index = i;
            break;
        }
    }


    for(int i = 1; i <= n; i++)
    {
        if(find_root(i) == find_root(special_index))
        {
            cout << 'W';
        }
        else
        {
            cout << 'L';
        }
    }
}

int main()
{
    upgrade_speed();
    read();
    solve();
    return 0;
}
