# include <bits/stdc++.h>
# define ll long long
using namespace std;

const int MAXN = 1e6 + 1;
int n;
int a[MAXN], b[MAXN];
vector<pair<int, int>> ab, ba;
vector<int> graph[MAXN];
bool visited[MAXN];
int leader_a, leader_b;

void upgrade_speed()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
}

void dfs(int u)
{
    if(visited[u]) return;
    visited[u] = true;
    for(auto& v : graph[u]) dfs(v);
}

void read()
{
    cin >> n;

    for(int i = 1; i <= n; i++)
    {
        cin >> a[i] >> b[i];
        ab.push_back({a[i], i});
        ba.push_back({b[i], i});
        leader_a = max(leader_a, a[i]);
        leader_b = max(leader_b, b[i]);
    }

    sort(ab.begin(), ab.end());
    sort(ba.begin(), ba.end());

    for(int i = 1; i < n; i++)
    {
        graph[ab[i - 1].second].push_back(ab[i].second);
    }

    for(int i = 1; i < n; i++)
    {
        graph[ba[i - 1].second].push_back(ba[i].second);
    }

    for(int i = 1; i <= n; i++)
    {
        if(a[i] == leader_a || b[i] == leader_b) dfs(i);
    }
}

void solve()
{
    for(int i = 1; i <= n; i++)
    {
        if(visited[i])
        {
            cout << 'W';
        }
        else
        {
            cout << 'L';
        }
    }
}

int main()
{
    upgrade_speed();
    read();
    solve();
    return 0;
}
