# include <iostream>
# include <vector>
# include <algorithm>
# include <queue>
using namespace std;

const long long INF=1e18;
const int MAX=5e3+11;

int n,m;
vector<pair<int,long long>> adj[MAX];
vector<pair<int,long long>> adj2[MAX];
long long dist1[MAX];

bool check()
{
    for(int i=1;i<=n;i++) dist1[i]=INF;
    for(int k=1;k<=n;k++)
    {
        bool f=0;
        for(int i=1;i<=n;i++)
        {
            for(pair<int,long long> nxt: adj[i])
            {
                if(dist1[i]+nxt.second<dist1[nxt.first])
                {
                    dist1[nxt.first]=dist1[i]+nxt.second;
                    f=1;
                }
            }
        }

        if(k==n and f) return true;
    }

    return false;
}

bool vis[MAX];
long long dist[MAX][MAX];

void dfs(int curr, int start)
{
    if(vis[curr]) return ;
    vis[curr]=1;

    for(pair<int,long long> nxt: adj2[curr])
    {
        dfs(nxt.first,start);
        dist[start][curr]=min(dist[start][curr],dist[start][nxt.first]+nxt.second);
    }
}

void calc(int start)
{
    for(int i=1;i<=n;i++)
    {
        vis[i]=0;
        dist[start][i]=INF;
    }

    vis[start]=1;
    dist[start][start]=0;
    for(int i=1;i<=n;i++) dfs(i,start);
}

int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);cout.tie(0);

    bool can=0;

    cin>>n>>m;
    for(int i=1;i<=m;i++)
    {
        int u,v;
        long long w;
        cin>>u>>v>>w;
        u++;v++;
        adj[u].push_back({v,w});
        adj2[v].push_back({u,w});
        if(u==v and w<=0) can=1;
    }

    if(can or check())
    {
        cout<<1<<"\n";
        return 0;
    }

    for(int i=1;i<=n;i++) calc(i);
    for(int i=1;i<=n;i++)
    {
        for(int j=1;j<=n;j++)
        {
            if(i==j) continue;
            if(dist[i][j]+dist[j][i]<=0) can=1;
        }
    }

    cout<<can<<"\n";

    return 0;
}


