# include <iostream>
# include <vector>
# include <algorithm>
# include <queue>
using namespace std;

const long long INF=1e18;
const int MAX=5e3+11;

int n,m;
vector<pair<int,long long>> adj[MAX];
long long dist1[MAX];

bool check()
{
    for(int i=1;i<=n;i++) dist1[i]=INF;
    for(int k=1;k<=n;k++)
    {
        bool f=0;
        for(int i=1;i<=n;i++)
        {
            for(pair<int,long long> nxt: adj[i])
            {
                if(dist1[i]+nxt.second<dist1[nxt.first])
                {
                    dist1[nxt.first]=dist1[i]+nxt.second;
                    f=1;
                }
            }
        }

        if(k==n and f) return true;
    }

    return false;
}


long long dist[MAX][MAX];

void dijkstra(int start)
{
    for(int i=1;i<=n;i++) dist[start][i]=INF;

    priority_queue<pair<long long,int>,vector<pair<long long,int>>,greater<pair<long long,int>>> pq;
    dist[start][start]=0;
    pq.push({0,start});
    while(pq.size()>0)
    {
        long long d;
        int curr;
        tie(d,curr)=pq.top();
        pq.pop();

        if(dist[start][curr]<d) continue;

        for(pair<int,long long> nxt: adj[curr])
        {
            if(dist[start][nxt.first]>d+nxt.second)
            {
                dist[start][nxt.first]=d+nxt.second;
                pq.push({dist[start][nxt.first],nxt.first});
            }
        }
    }

    //for(int i=1;i<=n;i++) cout<<start-1<<" "<<i-1<<":"<<dist[start][i]<<"\n";
}

int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);cout.tie(0);

    bool can=0;

    cin>>n>>m;
    for(int i=1;i<=m;i++)
    {
        int u,v;
        long long w;
        cin>>u>>v>>w;
        u++;v++;
        adj[u].push_back({v,w});
        if(u==v and w<=0) can=1;
    }

    if(can or check())
    {
        cout<<1<<"\n";
        return 0;
    }

    for(int i=1;i<=n;i++) dijkstra(i);
    for(int i=1;i<=n;i++)
    {
        for(int j=1;j<=n;j++)
        {
            if(i==j) continue;
            if(dist[i][j]+dist[j][i]<=0) can=1;
        }
    }

    cout<<can<<"\n";

    return 0;
}


