# include <iostream>
# include <vector>
# include <algorithm>
using namespace std;

const long long INF=1e18;
const int MAX=5e2+11;

int n,m;
vector<pair<int,long long>> adj[MAX];
long long dist[MAX][MAX];

int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);cout.tie(0);

    bool can=0;

    cin>>n>>m;
    for(int i=1;i<=n;i++)
    {
        for(int j=1;j<=n;j++) dist[i][j]=INF;
    }
    for(int i=1;i<=m;i++)
    {
        int u,v;
        long long w;
        cin>>u>>v>>w;
        u++;v++;
        adj[u].push_back({v,w});
        dist[u][v]=min(dist[u][v],w);
        if(u==v and w<=0) can=1;
    }

    for(int k=1;k<=n;k++)
    {
        for(int i=1;i<=n;i++)
        {
            for(int j=1;j<=n;j++)
            {
                dist[i][j]=min(dist[i][j],dist[i][k]+dist[k][j]);
            }
        }
    }

    for(int i=1;i<=n;i++)
    {
        for(int j=1;j<=n;j++)
        {
            if(dist[i][j]+dist[j][i]<=0) can=1;
        }
    }

    cout<<can<<"\n";

    return 0;
}


