#include <bits/stdc++.h>

using namespace std;

const int MAXN = 1e6 + 3;

int n;
pair<int, int> A[MAXN];
pair<int, int> B[MAXN];
bool ans[MAXN];
pair<int, int> pos[MAXN];
bool seg[MAXN * 4][3];

void built(int idx, int l, int r, int ix)
{
    if(l == r)
    {
        if(ix == 1)
            seg[idx][ix] = ans[A[l].second];
        else
            seg[idx][ix] = ans[B[l].second];
        return;
    }
    int mid = (l + r) / 2;
    built(idx * 2 + 0, l, mid, ix);
    built(idx * 2 + 1, mid + 1, r, ix);
    seg[idx][ix] = (seg[idx * 2][ix] || seg[idx * 2 + 1][ix]);
}

int L_query, R_query;
bool query(int idx, int l, int r, int ix)
{
    if(L_query <= l && R_query <= r)
        return seg[idx][ix];
    if(l > R_query || L_query > r)
        return 0;
    int mid = (l + r) / 2;
    bool c1, c2, c3;
    c1 = query(idx * 2, l, mid, ix);
    c2 = query(idx * 2 + 1, mid + 1, r, ix);
    c3 = (c1 || c2);
    return c3;
}

void point_update(int idx, int l, int r, int ix)
{
    if(L_query == l && R_query == r)
    {
        if(ix == 1)
            seg[idx][ix] = ans[A[l].second];
        else
            seg[idx][ix] = ans[B[l].second];
        return;
    }
    if(l > R_query || L_query > r)
        return;
    int mid = (l + r) / 2;
    point_update(idx * 2 + 0, l, mid, ix);
    point_update(idx * 2 + 1, mid + 1, r, ix);
    seg[idx][ix] = (seg[idx * 2][ix] || seg[idx * 2 + 1][ix]);
}

void FastIO()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    cout.tie(NULL);
}

void Read()
{
    cin >> n;
    for(int i = 1; i <= n; i++)
    {
        cin >> A[i].first >> B[i].first;
        A[i].second = B[i].second = i;
    }
}

void Solve()
{
    sort(A + 1, A + n + 1);
    sort(B + 1, B + n + 1);
    for(int i = 1; i <= n; i++)
    {
        pos[A[i].second].first = i;
        pos[B[i].second].second = i;
    }
    ans[A[n].second] = 1;
    ans[B[n].second] = 1;
    for(int i = n - 1; i >= 1; i--){
        if(A[i] != A[i + 1])
            break;
        ans[A[i].second] = 1;
    }
    for(int i = n - 1; i >= 1; i--){
        if(B[i] != B[i + 1])
            break;
        ans[B[i].second] = 1;
    }
    built(1, 1, n, 1);
    built(1, 1, n, 2);
    bool under_win;
    int j;
    for(int i = n - 1; i >= 1; i--){
        if(ans[A[i].second])
            continue;
        L_query = 1;
        R_query = i - 1;
        under_win = false;
        if(i != 1)
            under_win = query(1, 1, n, 1);
        j = pos[A[i].second].second;
        L_query = 1;
        R_query = j - 1;
        if(j != 1)
            under_win = (under_win || query(1, 1, n, 2));
        if(under_win)
        {
            ans[A[i].second] = true;
            L_query = R_query = i;
            point_update(1, 1, n, 1);
            L_query = R_query = j;
            point_update(1, 1, n, 2);
        }
    }
    for(int i = 1; i <= n; i++){
        if(ans[i])
            cout << 'W';
        else
            cout << 'L';
    }
}

int main()
{

    FastIO();
    Read();
    Solve();
    return 0;
}
