#include<bits/stdc++.h>
using namespace std;
#define f first
#define s second
const uint64_t MAX_N = 2e5+7;
const uint64_t MAX_M = 1e9 +7;
uint64_t basecnt = 0;
uint64_t n, m, q;
pair<uint64_t, uint64_t> range[MAX_N];
vector<pair<uint64_t, uint64_t>> vRange; /// the uint64_terval for segment tree edge
uint64_t t[32*MAX_N];
uint64_t lazy[32*MAX_N];

/// building is unnecessary because we start with all zeros

void push(uint64_t v, uint64_t tl, uint64_t tr){
    if(tl == tr){
        return;
    }
    uint64_t tm = (tl+tr)/2;
    t[2*v] += lazy[v];
    t[2*v + 1] += lazy[v];
    lazy[2*v] += lazy[v];
    lazy[2*v + 1] += lazy[v];
    lazy[v] = 0;
    return;
}

void update(uint64_t v, uint64_t l, uint64_t r, uint64_t tl, uint64_t tr, uint64_t val){
    //cout << "v: " << v << " l: " << l << " r: " << r << " tl: " << tl << " tr: " << tr << " val: " << val << endl;
    if(r < l) return;
    if(tl == l && tr == r){
        lazy[v]+= val;
        t[v] += val;
        return;
    }
    uint64_t tm = (tl+tr)/2;
    update(2*v, l, min(r, tm), tl, tm, val);
    update(2*v + 1, max(tm+1, l), r, tm+1, tr, val);
}

uint64_t querry(uint64_t v, uint64_t l, uint64_t r, uint64_t tl, uint64_t tr){
    if(r < l) return 0;
    if(tl == l && tr == r){
        return t[v];
    }
    if(lazy[v] >= 0){
        push(v, tl, tr);
    }
    uint64_t tm = (tl+tr)/2;
    return querry(2*v, l, min(r, tm), tl, tm) + querry(2*v + 1, max(tm+1, l), r, tm+1, tr);
}

void setupRanges(){
    vector<uint64_t> te; /// the end or start of the uint64_terval on a clock
    for(uint64_t i = 0; i < n; i++){
        if(range[i].f==-1){
            continue;
        }
        te.push_back(range[i].f);
        te.push_back(range[i].s);
    }
    te.push_back(n - 1);
    sort(te.begin(), te.end());

    vector<uint64_t> uniqueTe;
    uniqueTe.push_back(0);
    for(uint64_t i = 0; i < te.size(); i++){
        if(te[i] != uniqueTe.back()){
            uniqueTe.push_back(te[i]);
        }
    }

    vRange.push_back({uniqueTe[0],uniqueTe[0]});
    for(uint64_t i = 1; i < uniqueTe.size(); i++){
        if(uniqueTe[i] > uniqueTe[i-1]+1){
            vRange.push_back({uniqueTe[i-1]+1, uniqueTe[i]-1});
        }
        vRange.push_back({uniqueTe[i], uniqueTe[i]});
    }
    /*
    for(uint64_t i = 0; i < vRange.size(); i++){
        cout << vRange[i].f << " " << vRange[i].s << endl;
    }
    */
}
uint64_t findRangeIdx(uint64_t x){
    uint64_t l = 0;
    uint64_t r = vRange.size() - 1;
    while(l<r){
        uint64_t m = (l+r)/2;
        if(vRange[m].f <= x && x <= vRange[m].s){
            return m;
        }
        if(vRange[m].s < x){
            if(l == m){
                return r;
            }
            l = m;
        }
        if(vRange[m].f > x){
            r = m;
        }
    }
    return r;

}
void applyClocks(){
    for(uint64_t i = 0; i < n; i++){
        if(range[i].f == -1){
            continue;
        }
        uint64_t l = range[i].f;
        uint64_t r = range[i].s;
        uint64_t lidx = findRangeIdx(l);
        uint64_t ridx = findRangeIdx(r);
        //cout << l << " " << r << " " << lidx << " " << ridx << endl;
        //cout << "foundRange " << i << endl;
        if(l <= r){
            update(1, lidx, ridx, 0, vRange.size() - 1, 1);
        }else{
            update(1, 0, ridx, 0, vRange.size() - 1, 1);
            update(1, lidx, vRange.size()-1, 0, vRange.size() - 1, 1);
        }
        //cout << "out";

    }
}

void answerquerry(){
    uint64_t b;
    cin >> b;
    uint64_t bidx = findRangeIdx(b);
    cout << querry(1, bidx, bidx, 0, vRange.size()-1) + basecnt << endl;
}

int main(){
    cin >> n;
    cin >> m;
    for(uint64_t i = 0; i < n; i++){
        uint64_t ai, bi;
        cin >> ai >> bi;
        basecnt += ai/m;
        ai%=m;
        if(ai > 0){
            range[i].f = bi;
            range[i].s = (ai+bi-1)%m;
        }else{
            range[i].f = -1;
            range[i].s = -1;
        }
        //cout << i << ": " << range[i].f << " " << range[i].s << endl;
    }
    setupRanges();
    applyClocks();
    cin >> q;
    while(q--){
        answerquerry();
    }


}

