#include<bits/stdc++.h>
using namespace std;
#define f first
#define s second
const unsigned long long MAX_N = 2e5+7;
const unsigned long long MAX_M = 1e9 +7;
unsigned long long basecnt = 0;
unsigned long long n, m, q;
pair<unsigned long long, unsigned long long> range[MAX_N];
vector<pair<unsigned long long, unsigned long long>> vRange; /// the unsigned long longerval for segment tree edge
unsigned long long t[16*MAX_N];
unsigned long long lazy[16*MAX_N];

/// building is unnecessary because we start with all zeros

void push(unsigned long long v, unsigned long long tl, unsigned long long tr){
    if(tl == tr){
        return;
    }
    unsigned long long tm = (tl+tr)/2;
    t[2*v] += lazy[v];
    t[2*v + 1] += lazy[v];
    lazy[2*v] += lazy[v];
    lazy[2*v + 1] += lazy[v];
    lazy[v] = 0;
    return;
}

void update(unsigned long long v, unsigned long long l, unsigned long long r, unsigned long long tl, unsigned long long tr, unsigned long long val){
    //cout << "v: " << v << " l: " << l << " r: " << r << " tl: " << tl << " tr: " << tr << " val: " << val << endl;
    if(r < l) return;
    if(tl == l && tr == r){
        lazy[v]+= val;
        t[v] += val;
        return;
    }
    unsigned long long tm = (tl+tr)/2;
    update(2*v, l, min(r, tm), tl, tm, val);
    update(2*v + 1, max(tm+1, l), r, tm+1, tr, val);
}

unsigned long long querry(unsigned long long v, unsigned long long l, unsigned long long r, unsigned long long tl, unsigned long long tr){
    if(r < l) return 0;
    if(tl == l && tr == r){
        return t[v];
    }
    if(lazy[v] >= 0){
        push(v, tl, tr);
    }
    unsigned long long tm = (tl+tr)/2;
    return querry(2*v, l, min(r, tm), tl, tm) + querry(2*v + 1, max(tm+1, l), r, tm+1, tr);
}

void setupRanges(){
    vector<unsigned long long> te; /// the end or start of the unsigned long longerval on a clock
    for(unsigned long long i = 0; i < n; i++){
        if(range[i].f==-1){
            continue;
        }
        te.push_back(range[i].f);
        te.push_back(range[i].s);
    }
    te.push_back(n - 1);
    sort(te.begin(), te.end());

    vector<unsigned long long> uniqueTe;
    uniqueTe.push_back(0);
    for(unsigned long long i = 0; i < te.size(); i++){
        if(te[i] != uniqueTe.back()){
            uniqueTe.push_back(te[i]);
        }
    }

    vRange.push_back({uniqueTe[0],uniqueTe[0]});
    for(unsigned long long i = 1; i < uniqueTe.size(); i++){
        if(uniqueTe[i] > uniqueTe[i-1]+1){
            vRange.push_back({uniqueTe[i-1]+1, uniqueTe[i]-1});
        }
        vRange.push_back({uniqueTe[i], uniqueTe[i]});
    }
    /*
    for(unsigned long long i = 0; i < vRange.size(); i++){
        cout << vRange[i].f << " " << vRange[i].s << endl;
    }
    */
}
unsigned long long findRangeIdx(unsigned long long x){
    unsigned long long l = 0;
    unsigned long long r = vRange.size() - 1;
    while(l<r){
        unsigned long long m = (l+r)/2;
        if(vRange[m].f <= x && x <= vRange[m].s){
            return m;
        }
        if(vRange[m].s < x){
            if(l == m){
                return r;
            }
            l = m;
        }
        if(vRange[m].f > x){
            r = m;
        }
    }
    return r;

}
void applyClocks(){
    for(unsigned long long i = 0; i < n; i++){
        if(range[i].f == -1){
            continue;
        }
        unsigned long long l = range[i].f;
        unsigned long long r = range[i].s;
        unsigned long long lidx = findRangeIdx(l);
        unsigned long long ridx = findRangeIdx(r);
        //cout << l << " " << r << " " << lidx << " " << ridx << endl;
        //cout << "foundRange " << i << endl;
        if(l <= r){
            update(1, lidx, ridx, 0, vRange.size() - 1, 1);
        }else{
            update(1, 0, ridx, 0, vRange.size() - 1, 1);
            update(1, lidx, vRange.size()-1, 0, vRange.size() - 1, 1);
        }
        //cout << "out";

    }
}

void answerquerry(){
    unsigned long long b;
    cin >> b;
    unsigned long long bidx = findRangeIdx(b);
    cout << querry(1, bidx, bidx, 0, vRange.size()-1) + basecnt << endl;
}

int main(){
    cin >> n;
    cin >> m;
    for(unsigned long long i = 0; i < n; i++){
        unsigned long long ai, bi;
        cin >> ai >> bi;
        basecnt += ai/m;
        ai%=m;
        if(ai > 0){
            range[i].f = bi;
            range[i].s = (ai+bi-1)%m;
        }else{
            range[i].f = -1;
            range[i].s = -1;
        }
        //cout << i << ": " << range[i].f << " " << range[i].s << endl;
    }
    setupRanges();
    applyClocks();
    cin >> q;
    while(q--){
        answerquerry();
    }


}

