#include<bits/stdc++.h>
using namespace std;
#define f first
#define s second
const int MAX_N = 2e5+7;
const int MAX_M = 1e9 +7;
int basecnt = 0;
int n, m, q;
pair<int, int> range[MAX_N];
vector<pair<int, int>> vRange; /// the interval for segment tree edge
int t[16*MAX_N];
int lazy[16*MAX_N];

/// building is unnecessary because we start with all zeros

void push(int v, int tl, int tr){
    if(tl == tr){
        return;
    }
    int tm = (tl+tr)/2;
    t[2*v] += lazy[v];
    t[2*v + 1] += lazy[v];
    lazy[2*v] += lazy[v];
    lazy[2*v + 1] += lazy[v];
    lazy[v] = 0;
    return;
}

void update(int v, int l, int r, int tl, int tr, int val){
    //cout << "v: " << v << " l: " << l << " r: " << r << " tl: " << tl << " tr: " << tr << " val: " << val << endl;
    if(r < l) return;
    if(tl == l && tr == r){
        lazy[v]+= val;
        t[v] += val;
        return;
    }
    int tm = (tl+tr)/2;
    update(2*v, l, min(r, tm), tl, tm, val);
    update(2*v + 1, max(tm+1, l), r, tm+1, tr, val);
}

int querry(int v, int l, int r, int tl, int tr){
    if(r < l) return 0;
    if(tl == l && tr == r){
        return t[v];
    }
    if(lazy[v] >= 0){
        push(v, tl, tr);
    }
    int tm = (tl+tr)/2;
    return querry(2*v, l, min(r, tm), tl, tm) + querry(2*v + 1, max(tm+1, l), r, tm+1, tr);
}

void setupRanges(){
    vector<int> te; /// the end or start of the interval on a clock
    for(int i = 0; i < n; i++){
        if(range[i].f==-1){
            continue;
        }
        te.push_back(range[i].f);
        te.push_back(range[i].s);
    }
    te.push_back(n - 1);
    sort(te.begin(), te.end());

    vector<int> uniqueTe;
    uniqueTe.push_back(0);
    for(int i = 0; i < te.size(); i++){
        if(te[i] != uniqueTe.back()){
            uniqueTe.push_back(te[i]);
        }
    }

    vRange.push_back({uniqueTe[0],uniqueTe[0]});
    for(int i = 1; i < uniqueTe.size(); i++){
        if(uniqueTe[i] > uniqueTe[i-1]+1){
            vRange.push_back({uniqueTe[i-1]+1, uniqueTe[i]-1});
        }
        vRange.push_back({uniqueTe[i], uniqueTe[i]});
    }
    /*
    for(int i = 0; i < vRange.size(); i++){
        cout << vRange[i].f << " " << vRange[i].s << endl;
    }
    */
}
int findRangeIdx(int x){
    int l = 0;
    int r = vRange.size() - 1;
    while(l<r){
        int m = (l+r)/2;
        if(vRange[m].f <= x && x <= vRange[m].s){
            return m;
        }
        if(vRange[m].s < x){
            if(l == m){
                return r;
            }
            l = m;
        }
        if(vRange[m].f > x){
            r = m;
        }
    }
    return r;

}
void applyClocks(){
    for(int i = 0; i < n; i++){
        if(range[i].f == -1){
            continue;
        }
        int l = range[i].f;
        int r = range[i].s;
        int lidx = findRangeIdx(l);
        int ridx = findRangeIdx(r);
        //cout << l << " " << r << " " << lidx << " " << ridx << endl;
        //cout << "foundRange " << i << endl;
        if(l <= r){
            update(1, lidx, ridx, 0, vRange.size() - 1, 1);
        }else{
            update(1, 0, ridx, 0, vRange.size() - 1, 1);
            update(1, lidx, vRange.size()-1, 0, vRange.size() - 1, 1);
        }
        //cout << "out";

    }
}

void answerquerry(){
    int b;
    cin >> b;
    int bidx = findRangeIdx(b);
    cout << querry(1, bidx, bidx, 0, vRange.size()-1) + basecnt << endl;
}

int main(){
    cin >> n;
    cin >> m;
    for(int i = 0; i < n; i++){
        int ai, bi;
        cin >> ai >> bi;
        basecnt += ai/m;
        ai%=m;
        if(ai > 0){
            range[i].f = bi;
            range[i].s = (ai+bi-1)%m;
        }else{
            range[i].f = -1;
            range[i].s = -1;
        }
        //cout << i << ": " << range[i].f << " " << range[i].s << endl;
    }
    setupRanges();
    applyClocks();
    cin >> q;
    while(q--){
        answerquerry();
    }


}

