#include <bits/stdc++.h>
using namespace std;

#define endl '\n'
#ifndef LOCAL
#define cerr if(0)cerr
#endif // LOCAL

#define out(x) #x << " = " << x << " "


const int MAX_N = 5 * 1e3 + 10;
const int INF = 1e9 + 9;
int n, m;

vector <pair <int, int>> v[MAX_N];
int in[MAX_N], out[MAX_N], inWith[MAX_N];
int hadCycle[MAX_N];

bool solved = false;
int tim = 1;
int dfs (int x, int currW) {
    if (solved) return 0;
    cerr << "DFS(" << x << ", " << currW << ")" << endl;
    in[x] = tim;
    inWith[x] = currW;

    for (int i = 0; i < v[x].size(); i ++) {
        int curr = v[x][i].first;
        int nwei = currW + v[x][i].second;

        if (in[curr] == tim) {
            if (out[curr] != tim) {
                cerr << "Found a cycle with " << out(nwei) << "and " << out(inWith[curr]) << "when going from " << x << " to " << curr << endl;
                if (nwei - inWith[curr] <= 0) {
                    solved = true;
                    cerr << " -- SOLVED!" << endl;
                } else {
                    hadCycle[x] = tim;
                    cerr << " -- marking that " << x << " has a cycle" << endl;
                }

                out[x] = tim;
                return nwei;
            }

            cerr << "Found a dead end at " << curr << " and " << hadCycle[curr] << " " << tim << endl;
            if (hadCycle[curr] != tim) continue;
        }

        int nxt = dfs(curr, nwei);
        if (nxt != INF) {
            hadCycle[x] = true;
            cerr << " -- marking that " << x << " has a cycle (down)" << endl;
        }
        if (solved) return nxt;
    }

    out[x] = tim;
    return INF;
}

int main () {
    cin >> n >> m;

    for (int i = 0; i < m; i ++) {
        int x, y, w; cin >> x >> y >> w;
        v[x].push_back({y, w});
    }

    for (int i = 0; i < n; i ++) {
        dfs(i, 0);
        if (solved) {
            cout << 1 << endl;
            return 0;
        }
        tim ++;
        cerr << endl << endl << endl;
    }

    cout << 0 << endl;

    return 0;
}
