#include <bits/stdc++.h>

using namespace std;

typedef long long ull;

vector< vector< pair <int, int> > > adjList;

bool dfs(int src, int start, vector<bool>& visited, ull sum) {
    if (start == src && visited[start] == true) {
        if (sum <= 0) return true;
        else return false;
    }
    if (visited[start] == true) return false;

    visited[start] = true;

    bool res = false;
    for (auto [u, w] : adjList[start]) {
        res = res || dfs(src, u, visited, sum+w);
    }

    return res;
}

vector<ull> dijkstra(int src, int V) {
    vector<ull> dist(V, LLONG_MAX);
    priority_queue<
        pair<int, int>,
        vector<pair<int, int>>,
        greater<pair<int, int>>
    > pq;

    dist[src] = 0;
    pq.push({0, src});

    while (!pq.empty()) {
        auto [d, v] = pq.top();
        pq.pop();

        if (d > dist[v]) continue;
        for (auto [w, u] : adjList[v]) {
            if (dist[v] + w < dist[u]) {
                dist[u] = dist[v] + w;
                pq.push({dist[u], u});
            }
        }
    }

    return dist;
}

int main() {
    int n, m;
    cin >> n >> m;
    adjList.assign(n, vector<pair<int, int>>());

    for (int i = 0; i < m; i++) {
        int a, b, c;
        cin >> a >> b >> c;
        adjList[a].push_back({b, c});
    }

    bool res = false;
    for (int i = 0; i < n; i++) {
        vector<bool> tmp(n, false);
        if (dfs(i, i, tmp, 0)) {res = true; break;}
    }

    /*
    vector <vector<ull>> v(n);
    for (int i = 0; i < n; i++) v[i] = dijkstra(i, n);

    for (int i = 0; i < n; i++) {
        for (int j = 0; j < n; j++) {
            if (i != j && (!(ULLONG_MAX - v[i][j] < v[j][i]) && v[i][j] + v[j][i] <= 0)) {res = true; break;}
        }
        if (res) break;
    }
    //cout << v[0][3] << endl; problem */

    cout << res << endl;

    return 0;
}
