#include<iostream>
#include<vector>
#include<unordered_set>
using namespace std;

typedef pair<int,int> pi;
const int MAX_N = 5e3+42;

vector<pi> adj[MAX_N];
unordered_set<int> us;
bool visited[MAX_N];

void dfs(int u){
    if(visited[u]) return;
    visited[u] = true;
    for(pi e : adj[u])
        if(not visited[e.first])
            dfs(e.first);
}

int main(){
    int n, m;
    cin >> n >> m;
    for(int i = 0; i < m; ++i){
        int a, b, c;
        cin >> a >> b >> c;
        if(c <= 0) // samo za podzadacha 2
            adj[a].push_back({b, c});
    }
    for(int i = 0; i < n; ++i){
        for(int j = 0; j < n; ++j){visited[j] = false;}
        dfs(i);
       // cout << "From " << i << " we can reach: ";
        for(int j = 0; j < n; ++j){
            if(visited[j] and j != i){
                //cout << j << ", ";
                us.insert(i*10000+j);
            }
        }
       // cout << endl;
    }
    for(int i = 0; i < n; ++i){
        for(int j = 0; j < n; ++j){
            if(us.contains(i*10000+j) and us.contains(j*10000+i) and i != j){
                // you can j from i and i from j, i.e. this is a cycle
                // in podzad 1 and 2, we only care if a cycle exists
                //cout << i << " " << j << endl;
                cout << 1;
                return 0;
            }
        }
    }
    cout << 0;
    return 0;
}
/*
5 6
0 1 0
0 2 0
1 2 0
1 4 0
3 1 0
4 3 0
-> 1
5 6
0 1 0
0 2 0
1 2 0
1 4 0
1 3 0
4 3 0
*/
