#include<iostream>
#include<vector>
using namespace std;

const int MAXN = 5e3;
vector<vector<pair<int, int>>> trips (MAXN);
double best = 1e9;
bool v[MAXN];

void dfs(bool visited[], int curr, int cost, int currcost, int len, int history[], int prev, int n){
    bool visit[n];
    for(int i = 0; i < n; ++i){
        visit[i] = visited[i];
    }
    cost += currcost;
    history[curr] = cost;
    len ++;
    visit[curr] = true;
    v[curr] = true;
    for(auto i : trips[curr]){
        if(best <= 0) return;
        if(!v[i.first]){
            dfs(visit, i.first, cost, i.second, len, history, curr, n);
        }
        else if(visit[i.first] && (double)(cost + i.second - history[i.first]) / (double)len < best){
            best = (double)(cost + i.second - history[i.first]) / (double)len;
        }
    }
}


int main(){
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    int n, m, a, b, c;
    cin >> n >> m;
    for(int i = 0; i < m; ++i){
        cin >> a >> b >> c;
        pair <int, int> d;
        d.first = b;
        d.second = c;
        trips[a].push_back(d);
    }
    bool visited[n];
    fill_n(visited, n, false);
    fill_n(v, n, false);
    int history[n];
    for(int i = 0; i < n; ++i){
        if(!v[i])dfs(visited, i, 0, 0, -1, history, 0, n);
        if(best <= 0){
            break;
        }
    }
    cout << (best <= 0) * 1;
    return 0;
}
