#include<iostream>
#include<vector>
using namespace std;

const int MAXN = 5e3;
vector<vector<pair<int, int>>> trips (MAXN);
double best = 1e9;
bool v[MAXN];

void dfs(vector<bool> visited, int curr, int cost, int currcost, int len, vector<int> history){
    cost += currcost;
    history[curr] = cost;
    len ++;
    visited[curr] = true;
    v[curr] = true;
    for(auto i : trips[curr]){
        if(best <= 0) return;
        if(!visited[i.first]){
            dfs(visited, i.first, cost, i.second, len, history);
        }
        else if((double)(cost + i.second - history[i.first]) / (double)len < best){
            best = (double)(cost + i.second - history[i.first]) / (double)len;
        }
    }
}


int main(){
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    int n, m, a, b, c;
    cin >> n >> m;
    for(int i = 0; i < m; ++i){
        cin >> a >> b >> c;
        pair <int, int> d;
        d.first = b;
        d.second = c;
        trips[a].push_back(d);
    }
    vector<bool> visited (n);
    //fill_n(visited.begin(), n, false);
    //fill_n(v, n, false);
    vector<int> history (n);
    for(int i = 0; i < n; ++i){
        if(!v[i])dfs(visited, i, 0, 0, -1, history);
        if(best <= 0){
            break;
        }
    }
    cout << (best <= 0) * 1;
    return 0;
}
