#include <bits/stdc++.h>

/*

4
4 4
1 3
3 7
2 6

*/

using namespace std;

uint32_t N;

struct warrior_t{
    uint32_t a;
    uint32_t b;
    unordered_map<uint32_t, uint16_t> my_results;
};

vector<warrior_t> warriors;

void get_stats(){
    for(uint32_t i = 0, e = N - 1; i < e; i++){
        auto& cur_warrior = warriors[i];
        for(uint32_t j = i + 1; j < N; j++){
///         cout << "i = " << i << " ; j = " << j << "\n";
            int32_t w1_score = 0;
            int32_t w2_score = 0;
            if (cur_warrior.a > warriors[j].a){
                w1_score++;
            }
            else if (cur_warrior.a < warriors[j].a){
                w2_score++;
            }
            else{
                w1_score++;
                w2_score++;
            }
            if (cur_warrior.b > warriors[j].b){
                w1_score++;
            }
            else if (cur_warrior.b < warriors[j].b){
                w2_score++;
            }
            else{
                w1_score++;
                w2_score++;
            }
///         cout << "i = " << i << " ; j = " << j << "\n";
            int32_t score_res = w1_score - w2_score;
            if(score_res == 2){
                cur_warrior.my_results.insert({j, 2});
                warriors[j].my_results.insert({i, 0});
            }
            else if(score_res == -2){
                cur_warrior.my_results.insert({j, 0});
                warriors[j].my_results.insert({i, 2});
            }
            else{
                cur_warrior.my_results.insert({j, 1});
                warriors[j].my_results.insert({i, 1});
            }
///         cout << "i = " << i << " ; j = " << j << "\n";
        }
///     cout << "\n";
    }
    return;
}

int16_t defeated[1'000'000] = {};

unordered_set<uint32_t> visited;
bool DFS(vector<uint32_t>& path, uint32_t cur, uint32_t e){
    if(cur == e){
        path.pop_back();
        return true;
    }
    if(defeated[cur] == 3){
        return true;
    }
    visited.insert(cur);
    const auto& cur_warrior = warriors[cur];
    for(const auto& p : cur_warrior.my_results){
        if(p.second != 2 && defeated[p.first] != 2 && visited.find(p.first) == visited.end()){
            path.push_back(p.first);
            if(DFS(path, p.first, e)){
                return true;
            }
            path.pop_back();
        }
    }
    return false;
}

char simulate_battles(uint32_t must_win){
    defeated[must_win] = -1;
    /// -1 is root
    ///  0 is unsure
    ///  1 can be defeated directly
    ///  2 part of a chain
    ///  3 root of a chain
    auto& main_warrior = warriors[must_win];
    for(uint32_t i = 0; i < N; i++){
        auto& cur_warrior = warriors[i];
        if(defeated[i] != 0){
            continue;
        }
        if(main_warrior.my_results.find(i) != main_warrior.my_results.end()){
            if(main_warrior.my_results[i] == 0){
                vector<uint32_t> path = {};
                visited.clear();
                visited.insert(i);
                if(!DFS(path, i, must_win)){
                    return 'L';
                }
                for(auto& n : path){
                    n = 2;
                }
                defeated[i] = 3;
            }
            else{
                defeated[i] = 1;
            }
        }
    }
    return 'W';
}

void print_stats(){
    for(uint32_t i = 0; i < N; i++){
        auto& cur_warrior = warriors[i];
        cout << i << ":\n";
        cout << "a = " << cur_warrior.a << "\n";
        cout << "b = " << cur_warrior.b << "\n";
        for(const auto& p : cur_warrior.my_results){
            cout << i << " vs. " << p.first << " - " << p.second << "\n";
        }
        cout << "\n";
    }
    return;
}

int main(){
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    cin >> N;
    for(uint32_t i = 0; i < N; i++){
        uint32_t a, b;
        cin >> a >> b;
        warriors.push_back({a, b});
    }
    get_stats();
/// print_stats();
    for(uint32_t i = 0; i < N; i++){
        cout << simulate_battles(i);
        for(uint32_t i = 0; i < N; i++){
            defeated[i] = 0;
        }
    }
    cout << "\n";
    return 0;
}
