// sub4_scc_condensed_source_static.cpp
// Kosaraju on implicit graph + condensed DAG indegree check.
// If condensed DAG has exactly one component with indegree 0,
// all nodes in that component are winners; else all L.
//
// Compile: g++ -O2 -std=c++17 sub4_scc_condensed_source_static.cpp -o sol
// Adjust MAXN if needed.

#include <bits/stdc++.h>
using namespace std;

#ifndef MAXN
#define MAXN 10005
#endif

int N;
int A[MAXN], B[MAXN];

// First pass arrays
unsigned char used_arr[MAXN];
int order_arr[MAXN];
int order_sz;
int stk_node[MAXN], stk_next[MAXN];

// Second pass / components
int comp[MAXN];
int stack2[MAXN];
int C;

// Condensed graph bookkeeping (we don't store edges, only indegrees)
int indeg[MAXN];
int last_seen[MAXN];

inline bool edge_exists(int u, int v){
    return (A[u] >= A[v]) || (B[u] >= B[v]);
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    if(!(cin >> N)) return 0;
    if(N >= MAXN){
        cerr << "Increase MAXN to at least " << (N+1) << "\n";
        return 0;
    }
    for(int i=0;i<N;++i) cin >> A[i] >> B[i];

    // --- Kosaraju first pass (compute finish order), iterative DFS, implicit edges ---
    memset(used_arr, 0, N);
    order_sz = 0;

    for(int s = 0; s < N; ++s){
        if(used_arr[s]) continue;
        int sp = 0;
        stk_node[sp] = s;
        stk_next[sp] = 0;
        ++sp;
        while(sp > 0){
            int v = stk_node[sp-1];
            int &it = stk_next[sp-1];
            if(!used_arr[v]) used_arr[v] = 1;
            bool pushed = false;
            for(int w = it; w < N; ++w){
                it = w + 1;
                if(w == v) continue;
                if(edge_exists(v,w) && !used_arr[w]){
                    stk_node[sp] = w;
                    stk_next[sp] = 0;
                    ++sp;
                    pushed = true;
                    break;
                }
            }
            if(!pushed){
                order_arr[order_sz++] = v;
                --sp;
            }
        }
    }

    // --- Kosaraju second pass (assign components) ---
    for(int i=0;i<N;++i) comp[i] = -1;
    C = 0;
    for(int oi = order_sz - 1; oi >= 0; --oi){
        int start = order_arr[oi];
        if(comp[start] != -1) continue;
        int sp = 0;
        stack2[sp++] = start;
        comp[start] = C;
        while(sp > 0){
            int v = stack2[--sp];
            // reversed neighbors: w such that w -> v in original graph
            for(int w = 0; w < N; ++w){
                if(comp[w] == -1 && edge_exists(w, v)){
                    comp[w] = C;
                    stack2[sp++] = w;
                }
            }
        }
        ++C;
    }

    // --- Build condensed DAG indegrees (deduplicate with last_seen marker) ---
    for(int i=0;i<C;++i){
        indeg[i] = 0;
        last_seen[i] = -1;
    }

    for(int u = 0; u < N; ++u){
        int cu = comp[u];
        for(int v = 0; v < N; ++v){
            int cv = comp[v];
            if(cu == cv) continue;
            if(!edge_exists(u, v)) continue;
            // ensure we count edge cu -> cv only once across all u in cu
            if(last_seen[cv] != cu){
                last_seen[cv] = cu;
                ++indeg[cv];
            }
        }
    }

    // --- Find number of components with indegree zero ---
    int zero_cnt = 0;
    int zero_comp = -1;
    for(int c = 0; c < C; ++c){
        if(indeg[c] == 0){
            ++zero_cnt;
            zero_comp = c;
            if(zero_cnt > 1) break;
        }
    }

    string ans(N, 'L');
    if(zero_cnt == 1){
        // Nodes in the unique source component are winners
        for(int i=0;i<N;++i) if(comp[i] == zero_comp) ans[i] = 'W';
    }
    cout << ans << '\n';
    return 0;
}
