// sub3_dfs_from_each.cpp
// N <= 500
#include <bits/stdc++.h>
using namespace std;
using pii = pair<int,int>;

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int N;
    if(!(cin>>N)) return 0;
    vector<pii> s(N);
    for(int i=0;i<N;i++) cin>>s[i].first>>s[i].second;

    // Build adjacency lists (O(N^2) edges)
    vector<vector<int>> g(N);
    g.assign(N, {});
    for(int i=0;i<N;i++){
        g[i].reserve(N);
    }
    for(int i=0;i<N;i++){
        for(int j=0;j<N;j++){
            if(i==j) continue;
            if(s[i].first >= s[j].first || s[i].second >= s[j].second){
                g[i].push_back(j);
            }
        }
    }

    string ans(N,'L');
    vector<char> vis(N);
    // For each vertex, run BFS/DFS and check reachability to all nodes
    for(int u=0; u<N; ++u){
        fill(vis.begin(), vis.end(), 0);
        // iterative stack DFS
        vector<int> st;
        st.reserve(N);
        st.push_back(u);
        vis[u] = 1;
        int cnt = 0;
        while(!st.empty()){
            int v = st.back(); st.pop_back();
            cnt++;
            for(int w : g[v]){
                if(!vis[w]){
                    vis[w] = 1;
                    st.push_back(w);
                }
            }
        }
        if(cnt == N) ans[u] = 'W';
    }

    cout << ans << "\n";
    return 0;
}
