#include <bits/stdc++.h>
using namespace std;
using pii = pair<int,int>;

int N;
vector<pii> s;            // (A, B) for each player
vector<char> canWin;      // marks players that can win in some full sequence

inline bool can_beat(int a, int b){
    // a can beat b iff A[a] >= A[b] OR B[a] >= B[b]
    return (s[a].first >= s[b].first) || (s[a].second >= s[b].second);
}

void dfs_enumerate(const vector<int>& alive){
    int m = (int)alive.size();
    if(m == 1){
        canWin[alive[0]] = 1;
        return;
    }
    // choose unordered pair (i<j) among alive
    for(int i = 0; i < m; ++i){
        for(int j = i+1; j < m; ++j){
            int u = alive[i];
            int v = alive[j];
            bool ubeats = can_beat(u, v);
            bool vbeats = can_beat(v, u);
            // at least one of these must be true per problem condition
            if(ubeats){
                vector<int> next;
                next.reserve(m-1);
                for(int t=0;t<m;++t) if(t!=i && t!=j) next.push_back(alive[t]);
                next.push_back(u);
                dfs_enumerate(next);
            }
            if(vbeats){
                vector<int> next;
                next.reserve(m-1);
                for(int t=0;t<m;++t) if(t!=i && t!=j) next.push_back(alive[t]);
                next.push_back(v);
                dfs_enumerate(next);
            }
        }
    }
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    if(!(cin>>N)) return 0;
    s.resize(N);
    for(int i=0;i<N;++i) cin>>s[i].first>>s[i].second;
    canWin.assign(N, 0);
    vector<int> alive(N);
    iota(alive.begin(), alive.end(), 0);
    dfs_enumerate(alive);
    string ans;
    ans.resize(N);
    for(int i=0;i<N;++i) ans[i] = canWin[i] ? 'W' : 'L';
    cout << ans << "\n";
    return 0;
}
