#include <bits/stdc++.h>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int N;
    if (!(cin >> N)) return 0;
    vector<int> A(N), B(N);
    for (int i = 0; i < N; ++i) cin >> A[i] >> B[i];

    // 1) find candidate by single pass (standard)
    int cand = 0;
    for (int i = 1; i < N; ++i) {
        if ((A[cand] >= A[i]) || (B[cand] >= B[i])) {
            // cand can beat i -> keep cand
        } else {
            cand = i;
        }
    }

    // prepare orderings (ascending)
    vector<int> ordA(N), ordB(N);
    iota(ordA.begin(), ordA.end(), 0);
    iota(ordB.begin(), ordB.end(), 0);
    sort(ordA.begin(), ordA.end(), [&](int x, int y){
        if (A[x] != A[y]) return A[x] < A[y];
        return x < y;
    });
    sort(ordB.begin(), ordB.end(), [&](int x, int y){
        if (B[x] != B[y]) return B[x] < B[y];
        return x < y;
    });

    // ---------- Cheating forward BFS ----------
    vector<char> visF(N, 0);
    queue<int> q;
    visF[cand] = 1;
    q.push(cand);

    while (!q.empty()) {
        int u = q.front(); q.pop();

        // CHEAT: scan ordA starting at 0 each time, stop at first with A > A[u]
        for (int ia = 0; ia < N; ++ia) {
            int v = ordA[ia];
            if (A[v] <= A[u]) {
                if (!visF[v]) {
                    visF[v] = 1;
                    q.push(v);
                }
            } else {
                break; // stop at first > A[u], do not continue scanning
            }
        }

        // CHEAT: scan ordB starting at 0 each time, stop at first with B > B[u]
        for (int ib = 0; ib < N; ++ib) {
            int v = ordB[ib];
            if (B[v] <= B[u]) {
                if (!visF[v]) {
                    visF[v] = 1;
                    q.push(v);
                }
            } else {
                break; // stop at first > B[u]
            }
        }
    }

    int cntF = 0;
    for (int i = 0; i < N; ++i) if (visF[i]) ++cntF;
    if (cntF != N) {
        // If candidate doesn't reach all, output all L (as earlier correct logic)
        for (int i = 0; i < N; ++i) cout << 'L';
        cout << '\n';
        return 0;
    }

    // ---------- Cheating reverse BFS ----------
    vector<char> visR(N, 0);
    queue<int> qr;
    visR[cand] = 1;
    qr.push(cand);

    while (!qr.empty()) {
        int u = qr.front(); qr.pop();

        // reverse condition: need nodes v with A[v] >= A[u] or B[v] >= B[u]
        // CHEAT: scan ordA from end each time, but stop at first with A < A[u]
        for (int ia = N-1; ia >= 0; --ia) {
            int v = ordA[ia];
            if (A[v] >= A[u]) {
                if (!visR[v]) {
                    visR[v] = 1;
                    qr.push(v);
                }
            } else {
                break; // stop at first with A < A[u]
            }
        }

        // CHEAT: scan ordB from end each time, but stop at first with B < B[u]
        for (int ib = N-1; ib >= 0; --ib) {
            int v = ordB[ib];
            if (B[v] >= B[u]) {
                if (!visR[v]) {
                    visR[v] = 1;
                    qr.push(v);
                }
            } else {
                break; // stop at first with B < B[u]
            }
        }
    }

    // intersection of visF and visR -> winners
    string ans; ans.resize(N);
    for (int i = 0; i < N; ++i) ans[i] = (visF[i] && visR[i]) ? 'W' : 'L';
    cout << ans << '\n';
    return 0;
}
