#include <algorithm>
#include <iostream>
#include <numeric>
#include <vector>

std::string solve(std::vector <std::pair <int,int>> s)
{
    int n = s.size();
    std::vector <int> perm(n);
    std::vector <int> prefMIN(n);
    std::vector <int> suffMAX(n);
    std::iota(perm.begin(), perm.end(), 0);
    std::sort(perm.begin(), perm.end(), [&](int x, int y)
    {
        return s[x].first > s[y].first;
    });

    std::string ans(n, 'L');
    prefMIN[0] = s[perm[0]].second;
    for (int i = 1 ; i < n ; ++i)
    {
        prefMIN[i] = std::min(prefMIN[i - 1], s[perm[i]].second);
    }

    suffMAX[n - 1] = s[perm[n - 1]].second;
    for (int i = n - 2 ; i >= 0 ; --i)
    {
        suffMAX[i] = std::max(suffMAX[i + 1], s[perm[i]].second);
    }

    for (int i = 0 ; i < n ; ++i)
    {
        ans[perm[i]] = 'W';
        if (i + 1 < n && s[perm[i + 1]].first != s[perm[i]].first && prefMIN[i] > suffMAX[i + 1])
        {
            break;
        }
    }

    return ans;
}

int main()
{
    std::ios_base :: sync_with_stdio(0);
    std::cout.tie(nullptr);
    std::cin.tie(nullptr);

    int n;
    std::cin >> n;
    std::vector <std::pair <int,int>> s(n);
    for (int i = 0 ; i < n ; ++i)
    {
        std::cin >> s[i].first >> s[i].second;
    }

    std::cout << solve(s) << "\n";
    return 0;
}