#include <bits/stdc++.h>
using namespace std;
typedef long long ll;
#define endl '\n'

const int maxn = 5 + 5e3;
const ll INF = 1e18;
int n, m;
vector<pair<int, int>> g[maxn];

struct edge
{
    int u, v;
    ll w;
};

bool vis[maxn];
vector<pair<int, int>> st;
bool fl = false;

void dfs(int u)
{
    vis[u] = true;
    for (auto &[v, w] : g[u])
    {
        if (!vis[v])
        {
            st.push_back({v, w});
            dfs(v);
        }
        else
        {

            int sum = w;
            while (!st.empty() && st.back().first != v)
            {
                sum += st.back().second;
                st.pop_back();
            }

            if (sum == 0)
            {
                cout << 1 << endl;
                fl = true;
                return;
            }
        }
    }
}

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr), cout.tie(nullptr);

    cin >> n >> m;
    vector<edge> edges(m);
    for (int i = 0; i < m; i++)
    {
        int a, b;
        ll c;
        a++, b++;
        cin >> a >> b >> c;
        edges[i] = {a, b, c};
        g[a].push_back({b, c});
    }

    vector<ll> dist(n + 1, INF);
    dist[1] = 0;
    for (int i = 0; i < n; i++)
    {
        bool fl = true;
        for (auto &[u, v, w] : edges)
            if (dist[v] > dist[u] + w)
            {
                dist[v] = dist[u] + w;
                fl = false;
            }

        if (!fl && i == (n - 1))
        {
            cout << 1 << endl;
            return 0;
        }
    }

    if (!fl)
        cout << 0 << endl;
}