#include <bits/stdc++.h>
using namespace std;
typedef long long ll;
#define endl '\n'

const int maxn = 5 + 5e3;
const ll INF = 1e18;
int n, m;
vector<array<ll, 3>> edges[maxn];
bool vis[maxn];
ll ans = INF, cycle_len = 0;

bool find_cycle(int u, int end, ll &sum, int &sz, vector<bool> &used)
{
    for (auto &[v, w, id] : edges[u])
    {
        if (v == end)
        {
            sum += w;
            sz++;
            return true;
        }
        if (!used[id])
        {
            used[id] = true;
            if (find_cycle(v, end, sum, sz, used))
            {
                sum += w;
                sz++;
                return true;
            }
        }
    }
    return false;
}

void dfs(int u)
{
    for (auto &[v, w, id] : edges[u])
    {
        if (!vis[id])
        {
            vis[id] = true;
            dfs(v);
        }
        else
        {
            ll sum = 0;
            int sz = 0;
            vector<bool> used(m + 1, false);
            if (find_cycle(v, v, sum, sz, used) && sum < ans)
            {
                ans = sum;
                cycle_len = sz;
            }
        }
    }
}

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr), cout.tie(nullptr);

    cin >> n >> m;
    for (int i = 0; i < m; i++)
    {
        int a, b;
        ll c;
        a++, b++;
        cin >> a >> b >> c;
        edges[a].push_back({b, c, i});
    }

    for (int i = 1; i <= n; i++)
        if (!vis[i])
            dfs(i);

    if (ans == INF)
    {
        cout << 0 << endl;
        return 0;
    }

    if (ans <= 0LL)
        cout << 1 << endl;
    else
    {
        cout << 0 << endl;
    }
}