#include <bits/stdc++.h>
using namespace std;
typedef long long ll;
#define endl '\n'

const int maxn = 5 + 5e3;
const ll INF = 1e18;
int n, m;
vector<pair<int, ll>> edges[maxn];
bool vis[maxn];
ll ans = INF;

bool find_cycle(int u, int end, ll &sum, vector<bool> &used)
{
    used[u] = true;
    for (auto &[v, w] : edges[u])
    {
        if (v == end)
        {
            sum -= w;
            return true;
        }
        if (!used[v])
        {
            if (find_cycle(v, end, sum, used))
            {
                sum -= w;
                return true;
            }
        }
    }
    return false;
}

void dfs(int u)
{
    vis[u] = true;
    for (auto &[v, w] : edges[u])
    {
        if (!vis[v])
            dfs(v);
        else
        {
            ll sum = 0;
            vector<bool> used(n + 1, false);
            if (find_cycle(v, v, sum, used))
                ans = min(ans, sum);
        }
    }
}

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr), cout.tie(nullptr);

    cin >> n >> m;
    for (int i = 0; i < m; i++)
    {
        int a, b;
        ll c;
        a++, b++;
        cin >> a >> b >> c;
        edges[a].push_back({b, c});
    }

    for (int i = 1; i <= n; i++)
        if (!vis[i])
            dfs(i);

    if (ans <= 0LL)
        cout << 1 << endl;
    else
        cout << 0 << endl;
}