#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

int n;
vector<pair<int, pair<long long, long long>>> people;
vector<long long> is_winning;

bool sort_vector(pair<int, pair<long long, long long>> p1, pair<int, pair<long long, long long>> p2){
    return p1.second.first < p2.second.first;
}

void read(){
    cin >> n;
    for(int i = 0; i < n; i++){
        long long a, b;
        cin >> a >> b;
        people.push_back({i,{a, b}});
        is_winning.push_back(0);
    }

    sort(people.begin(), people.end(), sort_vector);
    is_winning[people[n-1].first] = 1;
}

void solve(){
    for(long long i = n-2; i >= 0; i--){
        if(people[i].second.first == people[n-1].second.first || (people[i].second.second > people[n-1].second.second && people[i].second.second > people[i+1].second.second)){
            is_winning[people[i].first] = 1;
        }
    }

    for(long long i = 0; i < n; i++){
        if(is_winning[i] == 1){
            cout << 'W';
        } else {
            cout << 'L';
        }
    }
}

int main(){
    read();
    solve();
    return 0;
}
