#include <bits/stdc++.h>
using namespace std;

const int MAXN = 5e3 + 5;

int n,m;

struct SP
{
    int a,b,c;
};
vector<SP>sp;

struct edge
{
    int ver,dist;
    edge(){}
    edge(int vi, int di)
    {
        ver = vi;
        dist = di;
    }
    bool operator<(const edge& ed) const
    {
        return dist > ed.dist;
    }
};

vector<edge>g[MAXN];

void read()
{
    cin >> n >> m;
    sp.resize(m);
    for(int i = 0; i < m; i++)
    {
        cin >> sp[i].a >> sp[i].b >> sp[i].c;
        g[sp[i].a].push_back({sp[i].b,sp[i].c});
    }
}

unsigned long long d[MAXN],inf = -1;


void dijkstra(int s)
{
    memset(d,-1,sizeof(d));
    d[s] = 0;

    priority_queue<edge>q;
    q.push({s,0});

    while(!q.empty())
    {
        edge e = q.top();
        q.pop();

        if(e.dist <= d[e.ver])
        {
            for(edge nb : g[e.ver])
            {
                if(nb.dist + e.dist < d[nb.ver])
                {
                    nb.dist += e.dist;
                    d[nb.ver] = nb.dist;
                    q.push(nb);
                }
            }
        }
    }
}

int used[MAXN];
bool f = false;

void dfs(int beg)
{
    used[beg] = 1;
    for(edge nb : g[beg])
    {
        if(!used[nb.ver]) dfs(nb.ver);
        else if(used[nb.ver] == 1) f = true;
    }
    used[beg] = 2;
}
void is_cycle(int i)
{
    for(int i = 0; i < n; i++) used[i] = 0;
    dfs(1);
}
void solve()
{
    for(int i = 0; i < n; i++) is_cycle(i);
    cout << f << endl;
    /*for(int s = 0; s < n; s++)
    {
        dijkstra(s);
    }*/
}
int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    read();
    solve();
    return 0;
}
