#include<iostream>
#include<climits>
#include<queue>
#include<vector>
#define MAXN 5010
#define MAXM 100010
using namespace std;
long long cost[MAXN][MAXN];
pair<int,int> edges[MAXM];
vector<int> edge[MAXN];
long long dist[MAXN];
bool dijkstra(int st, int n)
{
    for(int i=0;i<=n;i++)dist[i]=1e16;
    priority_queue<pair<long long,int>> q;
    q.push({0,st});
    while(!q.empty())
    {
        long long val=-q.top().first;
        int curr=q.top().second;
        //cout<<curr<<" "<<val<<"A\n";
        q.pop();
        if(curr==st && dist[curr]==0)return 1;
        if(dist[curr]<val)continue;
        for(int i=0;i<edge[curr].size();i++)
        {
            int now=edge[curr][i];
            //cout<<curr<<" "<<now<<" "<<cost[curr][now]<<"B\n";
            if(val+cost[curr][now]<dist[now])
            {
                dist[now]=val+cost[curr][now];
                q.push({-dist[now],now});
            }
        }
    }
    return 0;
}
int cntr[MAXN];
int main()
{
    int n,m;
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cin>>n>>m;
    for(int i=1;i<=m;i++)
    {
        int u,v;
        long long x;
        cin>>u>>v>>x;
        edges[i]={u,v};
        cost[u][v]=x;
        edge[u].push_back(v);
        cntr[v]++;
    }
    for(int i=0;i<=n;i++)dist[i]=1e16;
    dist[0]=0;
    bool fl=0;
    for(int i=1;i<=n;i++)
    {
        for(int j=1;j<=m;j++)
        {
            int u=edges[j].first,v=edges[j].second;
            if(dist[u]+cost[u][v]<dist[v])
            {
                if(i==n){fl=1;}
                dist[v]=dist[u]+cost[u][v];
            }
        }
    }
    if(fl){cout<<"1\n";return 0;}

    for(int i=0;i<n;i++)
    {
        if(cntr[i]==0)continue;
        if(dijkstra(i,n)){fl=1;break;}
    }
    cout<<fl<<"\n";
}