#include <iostream>
#include <algorithm>
#include <vector>

using namespace std;

bool LOOP = false;
bool checked[5100];
vector<vector<int>> graph(5100);

void check_neighbours(int n, vector<int> path) {
    checked[n] = true;
    for (int el: graph[n]) {
        for (int past_el: path) {
            if (past_el == el) {
                LOOP = true;
                return;
            }
        }
        vector<int> new_path = {path};
        new_path.push_back(el);
        check_neighbours(el, new_path);
    }
}

int main() {

    int N, M;
    int a, b, c;

    cin >> N >> M;

    for (int i=0; i<N+1; i++) {
        checked[i] = false;
    }

    for (int i=0; i<M; i++) {
        cin >> a >> b >> c;

        graph[a].push_back(b);
    }

    for (int n=1; n<=N; n++) {
        if (!checked[n]) {
            check_neighbours(n, {});
        }
    }

    if (LOOP) {
        cout << 1;
    } else {
        cout << 0;
    }

    return 0;
}