#include <iostream>
#include <algorithm>
#include <vector>

using namespace std;

typedef long long ll;

void speed()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
}

struct fighter
{
    int a, b, i;

    fighter() {};

    fighter(int _a, int _b, int _i)
    {
        a = _a;
        b = _b;
        i = _i;
    }

    const bool operator < (const fighter &_f) const
    {
        if(a == _f.a)
            return (b < _f.b);

        return (a < _f.a);
    }
};

const int MAXN = (int)1e6 + 5;

struct SegmentTree
{
    struct node
    {
        int l, r;
        ll data;

        node()
        {
            l = r = -1;
            data = 0;
        }

        node(int _l, int _r, ll _data)
        {
            l = _l;
            r = _r;
            data = 0;
        }
    };

    vector <node> tree;

    SegmentTree()
    {
        tree.clear();
        tree.emplace_back();
    }

    void makeL(int node)
    {
        tree[node].l = tree.size();
        tree.emplace_back();
    }

    void makeR(int node)
    {
        tree[node].r = tree.size();
        tree.emplace_back();
    }

    void calc(int node)
    {
        ll ans = 0;
        if(tree[node].l != -1)
           ans += tree[tree[node].l].data;

        if(tree[node].r != -1)
            ans += tree[tree[node].r].data;

        tree[node].data = ans;
    }

    void update(int node, int l, int r, int qPos, ll val)
    {
        if(l == r)
        {
            tree[node].data += val;
            return;
        }

        int mid = (l + r) / 2;

        //cout << mid << ' ' << l << ' ' << r <<  ' ' << tree.size() << endl;

        if(qPos <= mid)
        {
            if(tree[node].l == -1)
                makeL(node);
            update(tree[node].l, l, mid, qPos, val);
        }
        else
        {
            if(tree[node].r == -1)
                makeR(node);
            update(tree[node].r, mid + 1, r, qPos, val);
        }

        calc(node);
    }

    ll query(int node, int l, int r, int ql, int qr)
    {
        if(r < ql || qr < l)
            return 0;

        if(ql <= l && r <= qr)
            return tree[node].data;

        if(tree[node].data == 0)
            return 0;

        int mid = (l + r) / 2;
        ll ans = 0;

        cout << l << ' ' << r << ' ' << mid << ' ' << ans << endl;
        if(tree[node].l != -1)
            ans += query(tree[node].l, l, mid, ql, qr);

        if(tree[node].r != -1)
            ans += query(tree[node].r, mid + 1, r, ql, qr);

        return ans;
    }
};

SegmentTree st;
fighter f[MAXN];
int ans[MAXN];
int n;

void print()
{
    cout << endl;
    for(int i = 1; i <= n; i++)
        cout << f[i].a << ' ' << f[i].b << ' ' << f[i].i << endl;
    cout << endl;
}

void read()
{
    int a, b;

    cin >> n;
    for(int i = 1; i <= n; i++)
    {
        cin >> a >> b;

        f[i] = {a, b, i};
    }

    sort(f + 1, f + n + 1);

    print();


}

void solve()
{
    //for(int i = 1; i <= n; i++)
    //    st.update(1, 1, n, f[i].b, 1);

    for(int i = 1; i <= n ; i++)
    {
        cout << i << ' ' << f[i].a << ' ' << f[i].b << ' ' << f[i].i << ' ' << endl;
        cout << endl;
        ans[f[i].i] += st.query(1, 1, n, f[i].b, 1e9);

        st.update(1, 1, n, f[i].b, 1);
    }

    for(int i = 1; i <= n; i++)
    {
        cout << ans[i] << ' ';
    }
    cout << endl;
}

int main()
{
    speed();

    read();

    solve();

    return 0;
}
/**
9
3 10
3 9
3 3
4 5
1 0
2 7
5 3
7 8
6 2
**/
