#include<iostream>
#include<vector>
using namespace std;
const int MAX_N=5e3+5;
const long long INF=(1LL<<60);

int n,m;
vector<pair<int,long long>>g[MAX_N];
vector<pair<pair<int,int>,long long>>edges;

long long dist[MAX_N];


bool checknegative(int s)
{
    for(int i=1;i<=n;i++)
    {
        dist[i]=INF;
    }
    dist[s]=0;

    int x;
    for(int times=0;times<n;times++)
    {
        x=-1;
        for(auto [pa,c]:edges)
        {
            int u=pa.first,v=pa.second;
            if(dist[u]==INF)continue;

            if(dist[u]+c<dist[v])
            {
                x=v;
                dist[v]=dist[u]+c;
            }
        }
    }
    return x!=-1;
}


int cnt[MAX_N];
bool dfs(int u)
{
    cnt[u]=1;
    for(auto [v,cost]:g[u])
    {
        if(cnt[v]==1)return 1;
        if(cnt[v]==0)
        {
            bool is=dfs(v);
            if(is)return 1;
        }
    }
    cnt[u]=2;
    return 0;
}

void cyclecheck()
{
    for(int i=0;i<n;i++)
    {
        if(cnt[i]==0)
        {
            if(dfs(i))
            {
                cout<<1<<"\n";
                return;
            }
        }
    }
    cout<<0<<"\n";
}

int main ()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    cout.tie(NULL);
    cin>>n>>m;

    long long mxc=-INF;
    for(int i=1;i<=m;i++)
    {
        int u,v;
        long long c;
        cin>>u>>v>>c;
        mxc=max(mxc,c);
        g[u].push_back({v,c});
        edges.push_back({{u,v},c});
    }

    if(mxc<=0)
    {
        cyclecheck();
        return 0;
    }

    for(int i=0;i<n;i++)
    {
        if(checknegative(i))
        {
            cout<<1<<"\n";
            return 0;
        }
    }

    cout<<0<<"\n";

    return 0;
}