#include<iostream>
#include<vector>
#include<algorithm>
using namespace std;
const int MAX_N=1e6+6;

int n;
pair<int,int>a[MAX_N];
vector<int>g[MAX_N],revg[MAX_N];


bool used[MAX_N];
vector<int>top;
void dfs(int u)
{
    used[u]=1;
    for(int v:g[u])
    {
        if(!used[v])dfs(v);
    }
    top.push_back(u);
}

int root[MAX_N];
int in[MAX_N];
vector<int>component;
void dfs2(int u)
{
    component.push_back(u);
    used[u]=1;
    for(int v:revg[u])
    {
        if(!used[v])dfs2(v);
    }
}

void scc()
{
    for(int i=1;i<=n;i++)used[i]=0;

    for(int i=1;i<=n;i++)
    {
        if(!used[i])
        {
            dfs(i);
        }
    }
    reverse(top.begin(),top.end());

    for(int i=1;i<=n;i++)used[i]=0;

    for(int u:top)
    {
        if(!used[u])
        {
            component.clear();
            dfs2(u);
            for(int v:component)root[v]=u;
        }
    }

    for(int u=1;u<=n;u++)
    {
        for(int v:g[u])
        {
            if(root[u]==root[v])continue;
            in[root[v]]++;
        }
    }

    for(int i=1;i<=n;i++)
    {
        if(in[root[i]]==0)
        {
            cout<<'W';
        }
        else cout<<'L';
    }

    cout<<"\n";
}

void addedge(int u,int v)
{
    g[u].push_back(v);
    revg[v].push_back(u);
}

int main ()
{
    ios_base::sync_with_stdio(false); 
    cin.tie(NULL);
    cout.tie(NULL);

    cin>>n;
    vector<pair<int,int>>orderf,orders;
    for(int i=1;i<=n;i++)
    {
        int u,v;
        cin>>u>>v;
        a[i]={u,v};
        orderf.push_back({u,i});
        orders.push_back({v,i});
    }
    stable_sort(orderf.begin(),orderf.end());
    stable_sort(orders.begin(),orders.end());

    for(int i=1;i<n;i++)
    {
        int idcur=orderf[i].second;
        int idprev=orderf[i-1].second;

        addedge(idcur,idprev);
        if(orderf[i-1].first==orderf[i].first)
        {
            addedge(idprev,idcur);
        }
    }
    for(int i=1;i<n;i++)
    {
        int idcur=orders[i].second;
        int idprev=orders[i-1].second;

        addedge(idcur,idprev);
        if(orders[i-1].first==orders[i].first)
        {
            addedge(idprev,idcur);
        }
    }
    

    /*for(int i=1;i<=n;i++)
    {
        for(int j=1;j<=n;j++)
        {
            if(a[i].first>=a[j].first or a[i].second>=a[j].second)
            {
                g[i].push_back(j);
                revg[j].push_back(i);
            }
        }
    }*/

    scc();


    return 0;
}