#include <bits/stdc++.h>
#define endl '\n'

using namespace std;

const int MAXN = 5e3+50;
const int64_t INF = 1e18;

int visited[2*MAXN];

class Graph
{
private:
    struct Edge
    {
        int u, v, ind;
        int64_t cost;

        Edge(){}
        Edge(int u, int v, int ind, int64_t cost)
            :u(u), v(v), ind(ind), cost(cost){}
    };
    int N;
    vector <Edge> graph[MAXN];
    int64_t dist[MAXN];
    int used[MAXN];

    bool DFS(int node, int it)
    {
        used[node] = it;
        for (Edge edge: graph[node])
        {
            int next = edge.v;
            if (used[next] == it)
                return true;

            if (used[next] != 0)
                continue;

            return DFS(next, it);
        }

        return false;
    }
public:
    Graph(int N)
        :N(N)
    {
        for (int i = 0; i < N; i++)
            dist[i] = INF;
    };

    void AddEdge(int u, int v, int ind, int64_t cost)
    {
        graph[u].emplace_back(u, v, ind, cost);

    }

    bool hasCycle()
    {
        memset(used, 0, sizeof(used));

        int it = 1;
        for (int i = 0; i < N; i++)
        {
            if (used[i] != 0)
                continue;

            if (DFS(i, it) == true)
                return true;

            it++;
        }

        return false;
    }
    bool Dijikstra(int node)
    {
        priority_queue <pair <int64_t, int>> pq;

        for (int i = 0; i < N; i++)
            dist[i] = INF;

        pq.push({0, node});

        int CNT = 0;
        while (!pq.empty() && CNT <= 10*N)
        {
            int currNode = pq.top().second;
            int64_t currDist = -pq.top().first;

            pq.pop();

            for (Edge edge:graph[currNode])
            {
                if (dist[edge.v] >= edge.cost + currDist)
                {
                    dist[edge.v] = edge.cost + currDist;
                    pq.push({-dist[edge.v], edge.v});
                    CNT++;
                }
            }
        }

        /*for (int i = 0; i < N; i++)
        {
            cout << "dist(" << node << ", " << i << ") -> " << dist[i] << endl;
        }*/

        return (dist[node] <= 0);
    }

};

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(0); cout.tie(0);

    int N, M;
    cin >> N >> M;

    Graph *graph = new Graph(N);
    for (int i = 0; i < M; i++)
    {
        int u, v;
        int64_t cost;
        cin >> u >> v >> cost;

        graph->AddEdge(u, v, i, cost);
    }

    if (graph->hasCycle() == false)
    {
        cout << 0 << endl;
        return 0;
    }

    bool ans = false;
    for (int i = 0; i < N; i++)
    {
        ans |= graph->Dijikstra(i);

    }
    cout << ans << endl;

    return 0;
}

/*
3 3
0 1 0
0 2 0
1 2 -1
*/
