#include <bits/stdc++.h>
#define endl '\n'

using namespace std;

const int MAXN = 5e3+50;
const int64_t INF = 1e18;

int visited[MAXN];
int incoming[MAXN];

class Graph
{
private:
    struct Edge
    {
        int u, v, ind;
        int64_t cost;

        Edge(){}
        Edge(int u, int v, int ind, int64_t cost)
            :u(u), v(v), ind(ind), cost(cost){}
    };
    int N;
    vector <Edge> graph[MAXN];
    int64_t dist[MAXN];
public:
    Graph(int N)
        :N(N){};

    void AddEdge(int u, int v, int ind, int64_t cost)
    {
        graph[u].emplace_back(u, v, ind, cost);

    }
    bool Dijikstra(int node)
    {
        memset(visited, 0, sizeof(visited));
        priority_queue <pair <int64_t, int>> pq;

        for (int i = 0; i < N; i++)
            dist[i] = INF;

        pq.push({0, node});
        while (!pq.empty())
        {
            int currNode = pq.top().second;
            int64_t currDist = -pq.top().first;

            pq.pop();

            for (Edge edge:graph[currNode])
            {
                if (dist[edge.v] < edge.cost + currDist)
                    continue;

                if (edge.cost + currDist <= 0 && visited[edge.ind])
                    return true;


                visited[edge.ind] = true;
                dist[edge.v] = edge.cost + currDist;
                pq.push({-dist[edge.v], edge.v});

            }
        }

        /*for (int i = 0; i < N; i++)
        {
            cout << "dist(" << node << ", " << i << ") -> " << dist[i] << endl;
        }*/

        return false;
    }

};

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(0); cout.tie(0);

    int N, M;
    cin >> N >> M;

    Graph *graph = new Graph(N);
    for (int i = 0; i < M; i++)
    {
        int u, v;
        int64_t cost;
        cin >> u >> v >> cost;

        graph->AddEdge(u, v, i, cost);
    }

    bool ans = false;
    for (int i = 0; i < N; i++)
    {
        ans |= graph->Dijikstra(i);
    }
    cout << ans << endl;

    return 0;
}

/*
3 3
0 1 0
0 2 0
1 2 -1
*/
