#include <bits/stdc++.h>
#define endl '\n'

using namespace std;

const int MAXN = 5e3+50;
const int64_t INF = 1e18;

bool visited[MAXN];

class Graph
{
private:
    struct Edge
    {
        int u, v;
        int64_t cost;

        Edge(){}
        Edge(int u, int v, int64_t cost)
            :u(u), v(v), cost(cost){}
    };
    int N;
    vector <Edge> graph[MAXN];
    int64_t dist[MAXN];
public:
    Graph(int N)
        :N(N){};

    void AddEdge(int u, int v, int64_t cost)
    {
        graph[u].emplace_back(u, v, cost);
    }
    bool Dijikstra(int node)
    {
        priority_queue <pair <int64_t, int>> pq;

        for (int i = 0; i < N; i++)
            dist[i] = INF;

        pq.push({0, node});
        visited[node] = true;
        int CNT = 0;
        while (!pq.empty() && CNT <= 3*N)
        {
            int currNode = pq.top().second;
            int64_t currDist = -pq.top().first;

            visited[currNode] = true;
            pq.pop();

            for (Edge edge:graph[currNode])
            {
                if (dist[edge.v] >= edge.cost + currDist)
                {
                    if (dist[edge.v] <= 0)
                        return true;

                    dist[edge.v] = edge.cost + currDist;
                    pq.push({-dist[edge.v], edge.v});
                    CNT++;
                }
            }
        }

        /*for (int i = 0; i < N; i++)
        {
            cout << "dist(" << node << ", " << i << ") -> " << dist[i] << endl;
        }*/

        return (dist[node] <= 0);
    }

};

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(0); cout.tie(0);

    int N, M;
    cin >> N >> M;

    Graph *graph = new Graph(N);
    for (int i = 0; i < M; i++)
    {
        int u, v;
        int64_t cost;
        cin >> u >> v >> cost;

        graph->AddEdge(u, v, cost);
    }

    bool ans = false;
    for (int i = 0; i < N; i++)
    {
        if (visited[i])
            continue;

        ans |= graph->Dijikstra(i);
    }
    cout << ans << endl;

    return 0;
}
