#include <bits/stdc++.h>
#define endl '\n'

using namespace std;

const int MAXN = 1e6+50;

struct Point
{
    int x, y, ind;
    Point(){}
    Point(int x, int y, int ind)
        :x(x), y(y), ind(ind){}

    bool operator< (const Point& other)
    {
        if (x != other.x)
            return x < other.x;

        return y < other.y;
    }
};

int N;
vector <Point> points;
vector <int> x_coordinates, y_coordinates;
map <int, int> encodeX, encodeY;
bool ans[MAXN];

class FenwickTree
{
private:
    int N;
    int tree[MAXN*4];

    int GetPrefix(int ind)
    {
        int ans = 0;
        while (ind)
        {
            ans += tree[ind];
            ind -= ind&(-ind);
        }

        return ans;
    }

public:
    FenwickTree(int N)
        :N(N){};

    void Update(int ind, int change)
    {
        while (ind <= N)
        {
            tree[ind] += change;
            ind += ind&(-ind);
        }
    }

    int Query(int l, int r)
    {
        return GetPrefix(r) - GetPrefix(l-1);
    }
};

void relabelPoints()
{
    sort(x_coordinates.begin(), x_coordinates.end());
    sort(y_coordinates.begin(), y_coordinates.end());

    int k1 = 1, k2 = 1;

    for (int x_coord:x_coordinates)
    {
        if (encodeX.find(x_coord) == encodeX.end())
            encodeX[x_coord] = k1++;
    }

    for (int y_coord:y_coordinates)
    {
        if (encodeY.find(y_coord) == encodeY.end())
            encodeY[y_coord] = k2++;
    }

    for (int i = 0; i < N; i++)
    {
        points[i].x = encodeX[points[i].x];
        points[i].y = encodeY[points[i].y];

        //cout << points[i].x << " " << points[i].y << endl;
    }

    sort(points.begin(), points.end());
}

void calcAns()
{
    int maxY = 0;
    for (int i = 0; i < N; i++)
    {
        maxY = max(maxY, points[i].y);
    }

    FenwickTree *tree = new FenwickTree(maxY+1);
    for (Point& point: points)
    {
        tree->Update(point.y, +1);
    }

    int l = -1, r = maxY;

    for (int i = N-1; i >= 0; i--)
    {
        int currX = points[i].x;
        int currY = points[i].y;

        bool currAns;

        if (l == -1)
        {
            currAns = true;
            while (i >= 0 && points[i].x == currX)
            {
                tree->Update(points[i].y, -1);
                ans[points[i].ind] = currAns;
                i--;
            }

            if (i == -1)
                break;

            i++;
            l = points[i].y;
        }

        else
        {
            bool canChangeL = (currY >= l);
            currAns = tree->Query(l, r);

            while (i >= 0 && points[i].x == currX)
            {
                //cout << "Removing: " << points[i].y << endl;
                tree->Update(points[i].y, -1);
                ans[points[i].ind] = currAns;
                i--;
            }

            if (i == -1)
                break;

            i++;
            if (canChangeL)
                l = min(l, points[i].y);
        }
    }
}
int main()
{
    ios::sync_with_stdio(false);
    cin.tie(0); cout.tie(0);

    cin >> N;
    points.resize(N);
    x_coordinates.resize(N);
    y_coordinates.resize(N);

    for (int i = 0; i < N; i++)
    {
        cin >> points[i].x >> points[i].y;
        points[i].ind = i;

        x_coordinates[i] = points[i].x;
        y_coordinates[i] = points[i].y;
    }

    relabelPoints();
    calcAns();


    for (int i = 0; i < N; i++)
    {
        if (ans[i] == true)
            cout << 'W';
        else
            cout << 'L';
    }

    cout << endl;

    return 0;
}
